

var loading = {
	
	init: function(settings) {

		loading.config = {
			$anchors: $("ul a"),
			target: $("#col-2"),
			root: "#col-2"
		}
		$.extend( loading.config, settings );	

		// wenn keine Objekte gefunden wurden, wird die Funktion abgebrochen
		if (!loading.config.$anchors.length) return;


		loading.setup();

	},

	setup: function() {
		loading.config.$anchors.click(function(e) {
			e.preventDefault();
			loading.url = $(this).attr("href");
			loading.manageStyles($(this));
		});
	},
	manageStyles: function($this) {
			loading.config.$anchors.removeClass("current");
			$this.addClass("current");
			loading.config.target.fadeOut("slow",function() {
				loading.getContent(function(){
					loading.config.target.fadeIn("slow");
				});
			});
	},
	getContent: function( callback ) {
		loading.config.target.load(loading.url + " " + loading.config.root + " > *",callback);
	}
}

// Wenn DOM geladen
$(document).ready(loading.init);
