﻿
var lightpopup = {


	init: function (settings) {

		//Default Werte
		lightpopup.config = {
			$thumbs: $("a.lightpopup"),
			slowSpeed:400,
			fastSpeed:200,
			fasterSpeed:100,
			maxOpacity:0.8,
			htmlWidth:500,
			htmlHeight:332
  	},


		$.extend( lightpopup.config, settings );	
		

	  // Wenn kein Vorschaubilder gefunden wurden
		if (!lightpopup.config.$thumbs.length) return;
	
		// benoetigte jQuery-Objekte
		lightpopup.jqObjects = {
			$imgContainer : $('#imgContainer'),
			$imgBox : $('#imgBox'),
			$controls : $('#controls'),
			$overlay : $("#overlay")
		};
		
		// Property ckecked spaeter, ob ein AJAX load vorliegt
		lightpopup.ajax = false;
	  // Variablen, deren Werte auch nach Ausführung der Funktion
	  //justifyImgBox erhalten bleiben
		lightpopup.imgHeight = 1;
		lightpopup.imgWidth = 1;
		// Variablen, die margin, padding und border speichern
		lightpopup.diffWidth =
	  lightpopup.jqObjects.$imgContainer.outerWidth(true) -
  	lightpopup.jqObjects.$imgContainer.width();
  
  	lightpopup.diffHeight =
			lightpopup.jqObjects.$imgContainer.outerHeight(true) -
			lightpopup.jqObjects.$imgContainer.height();

 		// Events der Uebersicht halber nach unten ausgelagert	
		lightpopup.onReady();

		// justifyImgBox wir beim Start aufgerufen
		lightpopup.justifyImgBox(false,lightpopup.config.fastSpeed);
 
	},

	
  //loading lädt Bild und ruft PlugIn imagesLoaded auf
  //@ param String Bildquelle
	loadImg: function(src) {

		// Load AJAX
		var types = ['xml','txt','html','htm'];
		var type = src.slice(src.indexOf(".")+1);
		lightpopup.ajax = false;
		for (i in types) {
			if (type == types[i]) 	lightpopup.ajax = true;
		}
		// wenn AJAX
		if (lightpopup.ajax) {	
//			var url = $(this).attr("href");
				lightpopup.jqObjects.$imgBox.load(src,function(){
				lightpopup.openImgBox(false);
				});
			return;
		}
		// Load AJAX Ende		


		var findImg = lightpopup.jqObjects.$imgBox.find("img");
		(findImg.length) ? findImg.fadeOut(100,function() {loading()}) : loading();
		function loading() {
			var img = new Image();
			img.src = src;
			$(img).imagesLoaded(function() {
				lightpopup.openImgBox($(img));
			});
		}
	},

	//openImgBox oeffnet imgBox
	openImgBox: function(img) {

		if (img.length) {
			lightpopup.jqObjects.$imgBox.html(img);
			lightpopup.jqObjects.$imgBox.find("img").hide();
		}

		lightpopup.jqObjects.$overlay.fadeTo(lightpopup.config.fastSpeed,lightpopup.config.maxOpacity,function() {
			lightpopup.formatImgBox();
		});
	},
	
	// formatImgBox formatiert imgBox
	formatImgBox: function() {

		// wenn ein Bild geladen wird
		if (!lightpopup.ajax) {
			lightpopup.jqObjects.$imgContainer.css({
				display:"block"
			}).find('img').css({display:"block"});
			var thisHeight = lightpopup.jqObjects.$imgBox.find("img").height();
			var thisWidth = lightpopup.jqObjects.$imgBox.find("img").width();
			setDimensions();
			lightpopup.jqObjects.$imgBox.find("img").css({height:lightpopup.imgHeight,width:lightpopup.imgWidth});
			lightpopup.jqObjects.$imgBox.find("img").animate({
				opacity:1,
				height:lightpopup.imgHeight,
				width:lightpopup.imgWidth
			}, lightpopup.config.slowSpeed);
		}

		// wenn AJAX geladen wird
		if (lightpopup.ajax) {
			lightpopup.jqObjects.$imgContainer.css({
				display:"block"
			});
			var thisHeight = lightpopup.config.htmlHeight;
			var thisWidth = lightpopup.config.htmlWidth;
			setDimensions();
			lightpopup.jqObjects.$imgBox.css({height:lightpopup.imgHeight,width:lightpopup.imgWidth});
		}

		function setDimensions() {
			lightpopup.imgHeight = thisHeight;
			lightpopup.imgWidth = thisWidth;
		}
		lightpopup.jqObjects.$imgBox.animate({height:lightpopup.imgHeight,width:lightpopup.imgWidth},lightpopup.config.slowSpeed);
		lightpopup.justifyImgBox(true,lightpopup.config.slowSpeed);
	},
  
	// justifyImgBox richtet imgBox aus
	//@ dist bestimmt, ob Bildgroesse mit berechnet wird
	justifyImgBox: function(dist,speed) {
		var include = {
			height:0,
			width:0
		}
		if (dist) {
			include.height = lightpopup.imgHeight + lightpopup.diffHeight;
			include.width = lightpopup.imgWidth + lightpopup.diffWidth;
		}
		var top = Math.round(($(window).height() - include.height) / 2 );
		var left = Math.round(($(window).width() - include.width) / 2 );
		lightpopup.jqObjects.$imgContainer.animate({top:top,left:left},speed);
	},

	//changeImg aehnlich der Slideshow,
	//sucht das naechste/vorherige Bild
	// @param direction: Richtung, in die gesucht wird
	
	changeImg: function(direction) {
		var current = lightpopup.config.$thumbs.filter(".current");
		current.removeClass("current");
		if (direction == "forward") {
			current = current.next().length ? current.next() : lightpopup.config.$thumbs.first();
		}
		if (direction == "back") {
			current = current.prev().length ? current.prev() : lightpopup.config.$thumbs.last();
		}
		current.addClass("current");
		return current;
	},
  
  //Eventhandler
  //
  // Klick auf Thumb
  // @param Event
	onReady: function() {
		lightpopup.config.$thumbs.click(function(e) {
 	   e.preventDefault();
 	   var imgSrc = $(this).attr("href");
 	   $(this).addClass("current");
 	   lightpopup.loadImg(imgSrc);
  	});
 	 // Klick auf Abdecker
 	 // @param Event
		lightpopup.jqObjects.$overlay.click(function(e) {
			var overlay = $(this);
			lightpopup.jqObjects.$imgContainer.fadeOut(lightpopup.config.fastSpeed,function() {
				overlay.fadeOut(lightpopup.config.fastSpeed);
			});
		});
		//Klick auf grosses Bild, naechstes wird aufgerufen
		lightpopup.jqObjects.$imgBox.click(function() {
			lightpopup.loadImg(lightpopup.changeImg("forward").attr("href"));
		});
		//Klick auf Button vorwaerts, naechstes wird aufgerufen
		// @param Event
		lightpopup.jqObjects.$controls.find("a.forward").click(function(e) {
			e.preventDefault();
			lightpopup.loadImg(lightpopup.changeImg("forward").attr("href"));
		});
		//Klick auf Button zureck, vorheriges wird aufgerufen
		// @param Event
		lightpopup.jqObjects.$controls.find("a.back").click(function(e) {
			e.preventDefault();
			lightpopup.loadImg(lightpopup.changeImg("back").attr("href"));
		});

		// bei jedem resize wird imgContainer ausgerichtet
		$(window).resize(function() {
			if(!lightpopup.jqObjects.$imgContainer.filter(":visible").length) return;
				lightpopup.justifyImgBox(true,lightpopup.config.fasterSpeed);
		});
	}
}
// Wenn DOM geladen
$(document).ready(function() {
  // LightPopUp
  // @settings $thumbs, slowSpeed usw...
  lightpopup.init();
});
