﻿
var json = {
	

	init: function(settings) {

		json.$objects = {
			load: $("ul a.load"),
			reset: $("ul a.reset"),
			target: $("#col-2"),
			msg: $("#msg")
		}
		
		$.extend( json.$objects, settings );	

		json.$objects.load.click(function(e) {
			e.preventDefault();
		
			if (!$(this).not(".current").length) return;
			var lastTable = json.$objects.target.find("table").last();
			var url = $(this).attr("href");
			$(this).addClass("current");

			json.loadTableData(url,function() {
				(lastTable.next().length) ?
					lastTable.next().hide().fadeIn("slow") :
					json.$objects.target.find("table").hide().fadeIn("slow");
			});
		});

		json.$objects.reset.click(function(e) {
			e.preventDefault();
			json.$objects.load.removeClass("current");
			json.$objects.msg.empty();
			json.$objects.target.empty();
		});
	},
	
	loadTableData: function(url,callback) {
		var Data = {
			dataToTable: function(url) {
				var table = $('<table/>');
				$.getJSON( url, function( jsonObj ){
					if (jsonObj.header) {
						$.each( jsonObj.header, function(i, data) {
							Data.dataToRow(data,table,true);
						});
					}

					if (jsonObj.data) {
						$.each( jsonObj.data, function(i, data) {
							Data.dataToRow( data, table,false);
						});
					}
		
					json.$objects.target.append( table );
					if ($.isFunction(callback)){
						callback.call(this);
					}
				});

				$(document).ajaxError(function(e, xhr, settings, error) {
					json.$objects.msg.text("Fehler: " + error);
				});

				$(document).ajaxSuccess(function() {
					json.$objects.msg.text('Daten wurden geladen.');
				});
			},

			dataToRow: function(data, table,isHeader) {
				var tr = $("<tr/>");
				var cell = isHeader ? "<th/>" : "<td/>";
				$.each(data, function(i) {
					var td = $(cell);
					td.append(data[i] );
					tr.append(td);
				});

				table.append(tr);
			}
		}
		Data.dataToTable(url);
	}
}

$(document).ready(json.init);

