﻿
var scrolling = {
	
	
	init: function(settings) {

		scrolling.config = {
			$localAnchors: $("a[href*=#]")
		}
		
		$.extend( scrolling.config, settings );	

		if (!scrolling.config.$localAnchors.length) return;

		scrolling.$page = $('html, body');

		scrolling.config.$localAnchors.click(function(event) {
			event.preventDefault();
			scrolling.target = $(this).attr('href');
			scrolling.title = $(this).attr('title');
			scrolling.scrollManager();
		});
		scrolling.scrollManager();
	},

	scrollManager: function() {

		if (location.hash) {
			scrolling.scrollPage(location.hash);
			location.hash = "";
			return;
		}

		History.pushState({target:scrolling.target},scrolling.title,'');
		var target = History.getState().data.target;
		if (!target) return;
		scrolling.scrollPage(target);
	},
	

	scrollPage: function(target) {

		console.log(target);
		var $target = $(target);
		if (!$target.length) return;
		var position = $target.position().top;
		scrolling.$page.animate({scrollTop: position}, 1000);
	}
	
}
	
$(document).ready(scrolling.init);

