# jQuery.clientSideLogging, the jQuery client side logging plugin

## About

We've all been there; someone's encountering an error on your site, but everything's fine for you. What browser are they using? What's the error message? How many people is this affecting? Usually, you're in the dark: but no more!

With clientSideLogging, you can quietly log the errors that your users encounter (and also some debugging info of your own, if you like) and collate it server-side. Then, when you hear of a problem, you can check the logs — and see whether it's affecting one person or one thousand, one browser or many. You can even log useful information like screen resolution and browser size, for those inevitable small- or big-screen edge-cases.

The inspiration for this jQuery plugin came from [Karl Seguin's excellent article](http://openmymind.net/2012/4/4/You-Really-Should-Log-Client-Side-Error/).

## Usage

### Frontend

First things first, you need to set up your JavaScript code to log errors. Setup is easy; just include the jQuery plugin after jQuery, and call:

	$.clientSideLogging();

There are some default arguments that you can override. At the very least, you should set the `error_url`, `info_url`, and `log_url` settings to point to your backend:

	$.clientSideLogging({
		error_url: '/log?type=error',	// The url to which errors logs are sent
		info_url: '/log?type=info',		// The url to which info logs are sent
		log_url: '/log?type=log',		// The url to which standard logs are sent
		log_level: 1,					// The level at which to log. This allows you to keep the calls to the logging in your code and just change this variable to log varying degrees. 1 = only error, 2 = error & log, 3 = error, log & info
		native_error:true,				// Whether or not to send native js errors as well (using window.onerror).
		hijack_console:true,			// Hijacks the default console functionality (ie: all your console.error/info/log are belong to us).
		query_var: 'msg',				// The variable to send the log message through as.
		client_info: {					// Configuration for what info about the client's browser is logged.
			location:true,				//	The url to the page on which the error occurred.
			screen_size:true,			//	The size of the user's screen (different to the window size because the window might not be maximized)
			user_agent:true,			//	The user agent string.
			window_size:true			//	The window size.
		}
	});

Now, to actually use it! You can log values yourself, using three utility/wrapper functions; all of them accept either a plain string or a JavaScript object:

* `$.error(what)` - Send an error message to the server; also calls console.error (if available)
* `$.info(what)` - Send an info message to the server; also calls console.info (if available)
* `$.log(what)` - Send a log message to the server; also calls console.log (if available)

The log will be sent to the backend as a normal `POST` request, which might look like the following:

	$.post('/log?type=error&msg=YOUR_ERROR_MESSAGE');

#### Notes

* `native_error` is set to `true` by default. This means that all browser errors will also be captured and passed to the backend.
* `hijack_console` is set to `true` by default and will log to the server as well as display your normal console.error/info/log. If you wish to keep the functionality for $.error and console.error (for example) separate, set hijack_console to false.

### Backend

Sending errors is all well and good, but not if you've not got anything to receive them! So, you need to have something on your server that will store error messages sent to it.

Included in the distribution is a sample backend that should suffice for most people; it stores logs in a JSON-serialised text file, so it should be portable and relatively fast.

This default backend will write its logs to a file called `log.txt` in its current directory; simply edit the `LOG_FILE` constant to change this — something that's highly recommended, to keep things private.

### Viewing the logs

Also included with the distribution is a PHP frontend for parsing and displaying log entries; called `view_logs.php`, this script looks for the log file generated by the `log.php` script (make sure the `LOG_FILE` constant in the two of them matches) and displays a few nicely formatted tables of log information, and allows you to filter by severity.

## Credit

jQuery.clientSideLogging was developed by [Remy Bach](https://github.com/remybach) (JavaScript) and [Rob Miller](https://github.com/robmiller) (PHP).

## License

MIT License - [http://remybach.mit-license.org/](http://remybach.mit-license.org/)
