CREATE TABLE cache_entry (
    id INTEGER PRIMARY KEY,
    creation_time DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    last_access_time DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    expiration_date DATETIME NOT NULL,
    search_key TEXT NOT NULL,
    request BLOB,
    response BLOB,
    data BLOB,
    user_info BLOB
);
CREATE INDEX cache_entry_creation_time_idx ON cache_entry(creation_time);
CREATE INDEX cache_entry_last_access_time_idx ON cache_entry(last_access_time);
CREATE INDEX cache_entry_expiration_date_idx ON cache_entry(expiration_date);
CREATE INDEX cache_entry_search_key_idx ON cache_entry(search_key);
