use strict;

sub load_url {
  my ($url) = @_;
  print "<html><head><meta http-equiv=\"refresh\"".
    " content=\"0; $url\"></head></html>";
}

sub send_mail {
  my ($from, $to, $subject, $text) = @_;
  
  # Hat die Empfngeradresse eine gltige Form 
  # mit Name und Domain? 
  if (!$to || $to !~ 
     /([A-Za-z0-9_\-\.]+)\@([A-Za-z0-9_\-\.]+)\.(\w+)/
    ) {
    return 1; 
  }
  
  open MAIL, "| /usr/sbin/sendmail -t";
  print MAIL "To: $to";
  print MAIL "From: $from\n";
  print MAIL "Subject: $subject\n";
  print MAIL "\n$text\n";
  close MAIL;
}

sub date_time{
  my ($year,$month,$day,$hours,$minutes)
    = (localtime)[5,4,3,2,1];

  $year += 1900; # localtime-Jahr beginnt bei 1900
  $month++; # localtime-Monat beginnt bei Null

  # sicherstellen, da Werte zweistellig 
  # dargestellt werden:
  if($month<10) { $month="0".$month; }
  if($day<10) { $day="0".$day; }
  if($hours<10){$hours="0".$hours;}
  if($minutes<10){$minutes="0".$minutes;}

  return join("-", $year, $month, $day), 
	 join(":", $hours, $minutes);
}

sub identify_client {
  my $h = gethost($ENV{'REMOTE_ADDR'});
  my $hostname = $h->name;
  return $hostname;
}

return 1;
