#!/usr/bin/perl

use strict;
use CGI;
use DBI;

require "common-lib.pl";
require "template-lib.pl";
require "sql-lib.pl";
require "auth-lib.pl";
require "account-lib.pl";

my $cgi = new CGI;
my %args = $cgi->Vars;
my %value;

# Header ausgeben:
print "Content-type: text/html\n\n";

# formaction-Template-Variable setzen:
$value{'formaction'} = $ENV{'SCRIPT_NAME'};

# Ersten Useraccount erstellen, falls Parameter gegeben:
if($args{'first_time_login'}) {
  first_time_login(\%args);
  exit;
}

# User authentifizieren:
($value{'session_id'}, $value{'current_user'})
  = auth_user(\%args);
if(!$value{'session_id'}) { 
  parse_template("login.html", \%value);
  exit 0;
}

### Login war erfolgreich ###

# Useraccounts-Template aufrufen, falls Parameter gegeben:
if($args{'edit_account'}) {
  edit_user_accounts(\%args, \%value);
  exit;
}
# Anderenfalls ein Men o.. anzeigen:
parse_template("success.html", \%value);
