BEGIN {
  my ($username, $password, $db_name) = ("cgi","meinpasswort","cms");
  
  # Datenbanktreiber installieren:
  my $drh = DBI->install_driver( 'mysql' );

  if ( !defined $drh ) {
    die "Fehler beim Laden des Datenbanktreibers: $!\n";
  }
  
  # Datenbank-Handle erzeugen:
  $main::dbh = DBI->connect( "DBI:mysql:$db_name", $username, $password);
  
  if ( !defined $main::dbh ) {
    die "Fehler bei der Datenbankverbindung: $DBI::errstr";
  }
}

sub data_insert {
  # 1. Argument: Tabellenname
  # 2. Argument: Hasharray mit einzutragenden Werten
  my ($table, $args) = @_;

  # Feldinformationen lesen:
  my $sth=$main::dbh->prepare("select * from $table where ID=0");
  $sth->execute;
  my $names = $sth->{'NAME'};
  my $num_fields = $sth->{'NUM_OF_FIELDS'};
  
  # data-Statment aufbauen:
  my $query = "insert into $table set ";
  for(my $i=0;$i<$num_fields;$i++) {
    $query.=" $$names[$i] = ".$main::dbh->quote($$args{$$names[$i]});
    if($i < ($num_fields-1)){$query.=", ";}
  }
  
  # data-Statement ausfhren:
  $main::dbh->do($query);
  return $main::dbh->{'mysql_insertid'};
}

sub data_update {
  # 1. Argument: Tabellenname
  # 2. Argument: ID des zu aktualisierenden Eintrags
  # 3. Argument: Hasharray mit zu aktualisierenden Werten
  my ($table, $id, $args) = @_;

  # Feldinformationen auslesen:
  my $sth=$main::dbh->prepare("select * from $table where ID=0");
  $sth->execute;
  my $names = $sth->{'NAME'};
  my $num_fields = $sth->{'NUM_OF_FIELDS'};
  
  # data-Statement aufbauen:
  my $query = "update $table set ";
  for(my $i=0;$i<$num_fields;$i++) {
    $query.=" $$names[$i] = ".$main::dbh->quote($$args{$$names[$i]});
    if($i < ($num_fields-1)){$query.=", ";}
  }
  $query.=" where ID=$id";

  # data-Statement ausfhren:
  $main::dbh->do($query);
}


sub data_delete {
  # 1. Argument: Tabellenname
  # 2. Argument: ID des zu aktualisierenden Eintrags
  my ($table, $id) = @_;

  # data-Statement aufbauen:
  my $query = "delete from $table where ID=$id";
  $main::dbh->do($query);
}


sub get_data_from_table {
  my ($args, $value, $table, $rowid, $translate_chars)=@_;
  my $sth = $main::dbh->prepare("select * from $table where ID=$rowid");
  
  $sth->execute;
  if(!$sth->rows) { return 1; }
  
  my $names = $sth->{'NAME'};
  my $numFields = $sth->{'NUM_OF_FIELDS'};
  
  my $ref=$sth->fetchrow_arrayref;
  for (my $i=0;$i<$numFields;$i++) {
    if($translate_chars) { $$ref[$i]=~ s/\r/<BR>/g;}
    $$value{$$names[$i]}=$$ref[$i];
    $$args{$$names[$i]}=$$ref[$i];
  }
  $sth->finish;
  return ($args, $value);
}

return 1;
