sub parse_for_loops {
  # 1. Argument: Template-Dateiname
  # 2. Argument: Name der Schleife

  my ($template, $loopname) = @_;
  my $startloop = 0;
  my $loopbody;

  open FILE,"themes/html/$template" 
    or die "can not open themes/html/$template";
  while(<FILE>) {

    # <!--begin:$loopname--> bezeichnet den Beginn 
    # einer Schleife
    if($_ =~ /<!--begin:$loopname-->/) {
      $startloop = 1;
    }

    # <!--begin:$loopname--> bezeichnet das Ende 
    # einer Schleife
    if($_ =~ /<!--end:$loopname-->/) {
      $startloop = 0;
    }

    # Alles dazwischen wird in loop_body geschrieben:
    if($startloop) {
      $loopbody .= $_;
    }
  }

  # Schleifeninhalt zurckgeben:
  return $loopbody;
}


sub parse_loop {
  # 1. Argument: Schleifeninhalt, geliefert 
  #              aus TemplateLib::parse_for_loops
  # 2. Argument: Werte der Templatevariablen

  my ($loopbody, $value) = @_;
  
  my $output = "";
  foreach my $line (split/\n/, $loopbody) {
    # nach if-Ausdrcken suchen:
    if($line =~ /<!--if:(\w+)-->/) { 
      # Zeile enthlt If-Abfrage
      if(!$$value{$1}) { 
	$line = ""; 
      }
    }
    elsif($line =~ /<!--ifnot:(\w+)-->/) { 
      # Zeile enthlt If-Abfrage
      if($$value{$1}) { 
	$line = ""; 
      }
    }
    # Variablenwerte einsetzen:
    $line =~ s/\$(\w+)\$/$$value{$1}/g;
    $output .= $line
  }

  return $output;
}


sub parse_template {
  # 1. Argument: Templatedatei
  # 2. Argument: Hasharray mit Variablenwerten

  my ($template, $value) = @_;
  
  open FILE, "themes/html/$template" or 
    die "can not open themes/html/$template";
  while (<FILE>) {
    if(grep /<!--begin:(\w+)-->/,$_) { 
      # Schleife beginnt
      $loopstart=1;
    }
    
    if($loopstart) { # Schleife luft
      if($_ =~ /<!--end:(\w+)-->/) { 
	# Schleife endet hier, Schleifeninhalt 
	# wird an dieser Stelle eingefgt:
	$loopstart=0;
	$_ =~ s/<!--end:(\w+)-->/$$value{$1}/g;
	print $_;
      }
      next;
    }
    
    # nach if-Ausdrcken suchen:
    if($_ =~ /<!--if:(\w+)-->/) { 
      # Zeile enthlt If-Abfrage
      if(!$$value{$1}) { 
	$_ = ""; 
      }
    }
    # nach ifnot-Ausdrcken suchen:
    if($_ =~ /<!--ifnot:(\w+)-->/) { 
      # Zeile enthlt IfNot-Abfrage
      if($$value{$1}) { 
	$_ = ""; 
      }
    }

    # Templatevariablen durch Werte aus $value 
    # ersetzen:
    $_ =~ s/\$(\w+)\$/$$value{$1}/g;
    print $_;
  }
  close FILE;
}

return 1;
