using UnityEngine;

public class KameraBewegen : MonoBehaviour
{
    bool bewegung;
    float zeitGesamt;
    float winkelGesamt;
    float bewegungZeitStart;
    float zeitAnteilAlt;

    void Start()
    {
        bewegung = false;
        zeitGesamt = 3;
        winkelGesamt = 90;
        zeitAnteilAlt = 0;
    }

    void Update()
    {
        if (Input.GetKeyDown(KeyCode.C))
            transform.Translate(0.2f, -0.1f, 0.7f);
        else if (Input.GetKeyDown(KeyCode.V))
            transform.Translate(-0.2f, 0.1f, -0.7f);
        else if (Input.GetKeyDown(KeyCode.O))
            transform.Rotate(0, 5, 0);
        else if (Input.GetKeyDown(KeyCode.P))
            transform.Rotate(0, -5, 0);
        else if (Input.GetKeyDown(KeyCode.J))
            transform.RotateAround(new Vector3(-4, 0, 0),
               new Vector3(0, 1, 0), 5);
        else if (Input.GetKeyDown(KeyCode.K))
            transform.RotateAround(new Vector3(-4, 0, 0),
               new Vector3(0, 1, 0), -5);
        else if (Input.GetKeyDown(KeyCode.L) && !bewegung)
        {
            bewegung = true;
            bewegungZeitStart = Time.time;
        }

        if (bewegung)
        {
            float zeitAnteil = (Time.time - bewegungZeitStart) / zeitGesamt;
            float winkelAenderung = (zeitAnteil - zeitAnteilAlt) * winkelGesamt;
            transform.RotateAround(new Vector3(0, 0, 0),
               new Vector3(0, 1, 0), winkelAenderung);
            zeitAnteilAlt = zeitAnteil;
            Debug.Log(transform.eulerAngles.y);
            if (zeitAnteil >= 1)
                bewegung = false;
        }
    }
}
