using UnityEngine;
using TMPro;
using System.Collections.Generic;

public class Kurs : MonoBehaviour
{
    public TextMeshProUGUI ausgabe1, ausgabe2, ausgabe3, ausgabe4;

    public void VariablenUndDatentypen()
    {
        /* Deklaration */
        int ganzeZahl;
        float kommaZahl;
        string infoText;
        bool spielerAktiv;

        // Zuweisung
        ganzeZahl = 5;
        kommaZahl = -2.8f;
        infoText = "Hallo Welt";
        spielerAktiv = true;

        // Ausgabe
        ausgabe1.text = "int-Variable: " + ganzeZahl;
        ausgabe2.text = "float-Variable: " + kommaZahl;
        ausgabe3.text = "string-Variable: " + infoText;
        ausgabe4.text = "boolesche Variable: " + spielerAktiv;
    }

    public void Rechenoperatoren()
    {
        int ergebnis1, ergebnis2, ergebnis3;
        float ergebnis4;

        ergebnis1 = (7 - 4) * (2 + 5);
        ergebnis1 = ergebnis1 + 3;
        ergebnis1 += 10;

        ergebnis2 = 27 % 4;

        ergebnis3 = (int)2.8f;

        ergebnis4 = (5 + 2.2f) / 4;
        ergebnis4 *= 1.5f;

        ausgabe1.text = "1. Ergebnis: " + ergebnis1;
        ausgabe2.text = "2. Ergebnis: " + ergebnis2;
        ausgabe3.text = "3. Ergebnis: " + ergebnis3;
        ausgabe4.text = "4. Ergebnis: " + ergebnis4;
    }

    public void Verzweigungen()
    {
        int zahl = 25;

        if (zahl > 20)
        {
            ausgabe1.text = "Grer ";
            ausgabe1.text += "als 20";
        }

        if (zahl < 30)
            ausgabe2.text = "Kleiner als 30";

        if (zahl <= 10)
        {
            ausgabe3.text = "Kleiner oder gleich 10";
        }
        else
        {
            ausgabe3.text = "Grer als 10";
        }

        if (zahl > 25)
            ausgabe4.text = "Grer als 25";
        else if (zahl == 25)
            ausgabe4.text = "Gleich 25";
        else
            ausgabe4.text = "Kleiner als 25";
    }

    public void LogischeVerknuepfungen()
    {
        int zahl = 25;

        if (zahl > 20 && zahl < 30)
        {
            ausgabe1.text = "Zwischen 20 und 30";
        }

        if (zahl < 10 || zahl > 20)
        {
            ausgabe2.text = "Kleiner als 10 oder grer als 20";
        }

        if (zahl > 20 && zahl < 30 || zahl > 120 && zahl < 130)
        {
            ausgabe3.text = "Zwischen 20 und 30 oder zwischen 120 und 130";
        }

        if (!(zahl > 120 && zahl < 130))
        {
            ausgabe4.text = "Nicht zwischen 120 und 130";
        }
    }

    public void SchleifenUndZufallszahlen()
    {
        string aus;
        int wuerfel;

        aus = "";
        for (int i = 1; i <= 10; i++)
        {
            aus += i + "   ";
        }
        ausgabe1.text = aus;

        aus = "";
        for (int i = 1; i <= 10; i++)
        {
            wuerfel = Random.Range(1, 7);
            aus += wuerfel + "   ";
        }

        ausgabe2.text = aus;
        aus = "";
        for (int i = 1; i <= 5; i++)
            aus += Random.Range(2.5f, 2.8f) + "   ";
        ausgabe3.text = aus;

        aus = "";
        do
        {
            wuerfel = Random.Range(1, 7);
            aus += wuerfel + "   ";
            if (wuerfel == 6)
                break;
        }
        while (true);
        ausgabe4.text = aus;
    }

    public void Datenfelder()
    {
        int[] x;
        x = new int[5];

        x[0] = 12;
        x[1] = -5;
        x[2] = 18;
        x[3] = 6;
        x[4] = -3;

        string aus = "";
        for (int i = 0; i < x.Length; i++)
        {
            aus += x[i] + "   ";
        }
        ausgabe1.text = aus;

        int[,] y;
        y = new int[3, 8];
        for (int i = 0; i <= y.GetUpperBound(0); i++)
        {
            for (int k = 0; k <= y.GetUpperBound(1); k++)
            {
                y[i, k] = Random.Range(1, 7);
            }
        }

        aus = "";
        for (int k = 0; k <= y.GetUpperBound(1); k++)
            aus += y[0, k] + "   ";
        ausgabe2.text = aus;

        aus = "";
        for (int k = 0; k <= y.GetUpperBound(1); k++)
            aus += y[1, k] + "   ";
        ausgabe3.text = aus;

        aus = "";
        for (int k = 0; k <= y.GetUpperBound(1); k++)
            aus += y[2, k] + "   ";
        ausgabe4.text = aus;
    }

    public void Zeichenketten()
    {
        string x = "Das ist Nummer 42";
        ausgabe1.text = "Ganzer Text: " + x;

        ausgabe2.text = "Zwei Teiltexte: " + x.Substring(0, 3)
           + " / " + x.Substring(x.Length - 1, 1);

        int zahl = System.Convert.ToInt32(x.Substring(x.Length - 2, 2));
        ausgabe3.text = "Zahl, erhht: " + (zahl + 18);

        float a = 1.0f / 7;
        float b = 1000.0f / 7;
        ausgabe4.text = string.Format(
           "1. Zahl: {0,8:0.000}, 2. Zahl: {1,8:0.0}", a, b);
    }

    void Hallo()
    {
        ausgabe1.text = "Hallo Welt";
    }

    void GibSummeAus(int a, int b)
    {
        int c;
        c = a + b;
        ausgabe2.text = "Summe: " + c;
    }

    int BerechneSumme(int a, int b)
    {
        int c;
        c = a + b;
        return c;
    }

    void Verdoppeln(int[] f)
    {
        for (int i = 0; i < f.Length; i++)
            f[i] = f[i] * 2;
    }

    public void MethodenAufrufe()
    {
        Hallo();

        int x = 12;
        int y = 7;
        GibSummeAus(x, y);

        int z;
        z = BerechneSumme(x, y);
        ausgabe3.text = "Summe: " + z;

        int[] feld = new int[3];
        feld[0] = 22;
        feld[1] = 7;
        feld[2] = 13;
        Verdoppeln(feld);

        string aus = "";
        for (int i = 0; i < feld.Length; i++)
            aus += feld[i] + "   ";
        ausgabe4.text = "Nach dem Verdoppeln: " + aus;
    }

    public void GenerischeListen()
    {
        List<int> z;
        z = new List<int> { 12, -5 };
        z.Add(6);
        z.Add(-3);
        AusgabeListe(z, ausgabe1);

        z.Insert(0, -8);
        AusgabeListe(z, ausgabe2);

        z.RemoveAt(z.Count - 1);
        AusgabeListe(z, ausgabe3);

        z.RemoveAt(0);
        AusgabeListe(z, ausgabe4);
    }

    void AusgabeListe(List<int> a, TextMeshProUGUI ausgabeX)
    {
        string aus = "";
        for (int i = 0; i < a.Count; i++)
            aus += a[i] + "   ";
        ausgabeX.text = aus;
    }

    void AusgabeListe2(List<int> a, TextMeshProUGUI ausgabeX)
    {
        string aus = "";
        foreach (int elem in a)
            aus += elem + "   ";
        ausgabeX.text = aus;
    }

    void DatenSpeichern()
    {
        int ganzeZahl = 5;
        float kommaZahl = -2.8f;
        string infoText = "Hallo Welt";
        bool spielerAktiv = true;

        PlayerPrefs.SetInt("ganzeZahl", ganzeZahl);
        PlayerPrefs.SetFloat("kommaZahl", kommaZahl);
        PlayerPrefs.SetString("infoText", infoText);
        if (spielerAktiv)
            PlayerPrefs.SetInt("spielerAktiv", 1);
        else
            PlayerPrefs.SetInt("spielerAktiv", 0);
        PlayerPrefs.Save();
    }

    void DatenLaden()
    {
        int ganzeZahl = 0;
        float kommaZahl = 0.0f;
        string infoText = "";
        bool spielerAktiv = false;

        if (PlayerPrefs.HasKey("ganzeZahl"))
            ganzeZahl = PlayerPrefs.GetInt("ganzeZahl");
        if (PlayerPrefs.HasKey("kommaZahl"))
            kommaZahl = PlayerPrefs.GetFloat("kommaZahl");
        if (PlayerPrefs.HasKey("infoText"))
            infoText = PlayerPrefs.GetString("infoText");
        if (PlayerPrefs.HasKey("spielerAktiv"))
        {
            int spielerAktivZahl = PlayerPrefs.GetInt("spielerAktiv");
            if (spielerAktivZahl == 1)
                spielerAktiv = true;
            else
                spielerAktiv = false;
        }

        ausgabe1.text = "int-Variable: " + ganzeZahl;
        ausgabe2.text = "float-Variable: " + kommaZahl;
        ausgabe3.text = "string-Variable: " + infoText;
        ausgabe4.text = "bool-Variable: " + spielerAktiv;
    }

    public void LadenNachSpeicherung()
    {
        DatenSpeichern();
        DatenLaden();
    }

    public void LadenOhneSpeicherung()
    {
        PlayerPrefs.DeleteAll();
        DatenLaden();
    }
}

