using UnityEngine;
using TMPro;
using UnityEngine.SceneManagement;
using System;

public class Spieler : MonoBehaviour
{
    int szeneNummer;
    public GameObject gewinnEins, gewinnZwei;
    public Sprite[] spriteFeld = new Sprite[3];

    readonly float eingabeFaktor = 5;

    int punkte = 0;
    int punkteGesamt;
    public TextMeshProUGUI infoAnzeige;

    void Start()
    {
        Scene aktuelleSzene = SceneManager.GetActiveScene();
        szeneNummer = Convert.ToInt32(
           aktuelleSzene.name.Substring(5, 1));

        if (szeneNummer == 0)
            punkteGesamt = 0;
        else
            punkteGesamt = PlayerPrefs.GetInt("punkteGesamt");

        gewinnEins.GetComponent<SpriteRenderer>().sprite =
           spriteFeld[szeneNummer];
        gewinnZwei.GetComponent<SpriteRenderer>().sprite =
           spriteFeld[szeneNummer];
        infoAnzeige.text = "Szene: " + szeneNummer +
           ", Punkte: " + punkte + ", Gesamt: " + punkteGesamt;
    }

    void Update()
    {
        transform.position = new Vector3(
           transform.position.x + Input.GetAxis("Horizontal")
              * eingabeFaktor * Time.deltaTime,
           transform.position.y + Input.GetAxis("Vertical")
              * eingabeFaktor * Time.deltaTime, 0);
    }

    void OnCollisionEnter2D(Collision2D coll)
    {
        if (coll.gameObject.CompareTag("Gewinn"))
        {
            punkte++;
            punkteGesamt++;
            infoAnzeige.text = "Szene: " + szeneNummer +
               ", Punkte: " + punkte + ", Gesamt: " + punkteGesamt;
            Destroy(coll.gameObject);
            if (punkte == 2)
                Invoke(nameof(EndeSzene), 1);
        }
    }

    void EndeSzene()
    {
        PlayerPrefs.SetInt("punkteGesamt", punkteGesamt);

        if (szeneNummer == 0)
            SceneManager.LoadScene("Szene1");
        else if (szeneNummer == 1)
            SceneManager.LoadScene("Szene2");
        else if (szeneNummer == 2)
            infoAnzeige.text = "Gewonnen";
    }
}
