* [Burst compiler](index.md)
* [Get started](getting-started.md)
* [C# language support](csharp-language-support.md)
    * [HPC# overview](csharp-hpc-overview.md)
    * [Static read-only fields and static constructor support](csharp-static-read-only-support.md)
    * [String support](csharp-string-support.md)
    * [Calling Burst-compiled code](csharp-calling-burst-code.md)
    * [Function pointers](csharp-function-pointers.md)
    * [C#/.NET type support](csharp-type-support.md)
    * [C#/.NET System namespace support](csharp-system-support.md)
    * [DllImport and internal calls](csharp-burst-intrinsics-dllimport.md)
    * [SharedStatic struct](csharp-shared-static.md)
* [Burst compilation](compilation.md)
    * [Marking code for Burst compilation](compilation-burstcompile.md)
    * [Excluding code from Burst compilation](compilation-burstdiscard.md)
    * [Defining Burst options for an assembly](compilation-burstcompile-assembly.md)
    * [Burst compilation in Play mode](compilation-synchronous.md)
    * [Generic jobs](compilation-generic-jobs.md)
    * [Compilation warnings reference](compilation-warnings.md)
* [Burst intrinsics](csharp-burst-intrinsics.md)
    * [Burst intrinsics Common class](csharp-burst-intrinsics-common.md)
    * [Processor specific SIMD extensions](csharp-burst-intrinsics-processors.md)
        * [Arm Neon intrinsics reference](csharp-burst-intrinsics-neon.md)
* [Editor reference](editor-reference-overview.md)
    * [Burst menu reference](editor-burst-menu.md)
    * [Burst Inspector window reference](editor-burst-inspector.md)
* [Building your project](building-projects.md)
    * [Burst AOT Settings reference](building-aot-settings.md)
* [Optimization](optimization-overview.md)
    * [Debugging and profiling tools](debugging-profiling-tools.md)
    * [Loop vectorization](optimization-loop-vectorization.md)
    * [Memory aliasing](aliasing.md)
        * [NoAlias attribute](aliasing-noalias.md)
        * [Aliasing and the job system](aliasing-job-system.md)
    * [AssumeRange attribute](optimization-assumerange.md)
    * [Hint intrinsic](optimization-hint.md)
    * [Constant intrinsic](optimization-constant.md)
    * [SkipLocalsInit attribute](optimization-skiplocalsinit.md)
* [Modding support](modding-support.md)
