# Changelog

All notable changes to this package will be documented in this file.

## [2.10.0] - 2025-10-08

### Added

- Added a new Editor Toolbar Button for Unity Version Control that lets you view project status, track changes, and perform key actions with one click.
- Added Unity Version Control status icons to prefab assets in the hierarchy view in "Edit Mode".
- Added Unity Version Control actions to the prefab and prefab variant header context menus.

### Changed

- Improved overlay icons to align with the Unity Editor design. Added icons for "Controlled" and "Changed" items, removed the icon for "Private" items, and added a "Contains Changes" overlay for directories containing changes.

### Fixed

- Fixed applying shelves when some files cannot be checked out due to exclusive checkout lock rules. These files are now applied as local changes instead of failing the whole operation. A shelve report popup is displayed to the user.
- Fixed the missing "Hide" contextual menu on the Unity Version Control button in the Unity 6.3 Toolbar.
- Fixed incorrect tab name showing as "Unity.PlasticSCM.Editor.x" with no icon when upgrading a project to Unity 6.x.
- Fixed debug log "Package com.unity.collab-proxy version: 0.0.0" to output the actual package version.

## [2.9.3] - 2025-08-29

### Fixed

- Fixed the error that was thrown when the "Configure Unity Version Control" button is pressed in the Build Automation settings in Build Profiles

## [2.9.2] - 2025-08-19

### Fixed

- Fixed obsolete references to TreeViewState

## [2.9.1] - 2025-08-13

### Added

- Added the diff panel in the branches view
- Added a new view to manage labels
- New feature to inform users about available updates in the package
- Improved checkout speed for thousands of files
- Enriched scene assets in the hierarchy view with status overlay icon
- Enriched sub scene assets in the hierarchy view with status overlay icon
- Added Version Control actions to the scene header menu in the hierarchy view
- Added Version Control actions to sub scenes menu in the hierarchy view
- Implemented double-click action for pending changes view
- Implemented double-click action for the diff panel
- Implemented double-click action for the history view
- Updated all usages of TreeView to the new generic version in Unity 6000.2
- New feature to recommend users to enable Manual Checkout for Unity Assets when there are Lock Rules configured for the project
- Added empty states for different scenarios
- Added tutorial link for Smart Locks in empty state for locks view
- Added extra icons for known Unity file extensions

### Fixed

- Fixed undo shortcut for the PendingChanges view comments TextBox
- Fixed error message when clicking the 'Incoming changes' tab
- Fixed the error 'EndLayoutGroup: BeginLayoutGroup must be called first' in different scenarios
- Updated LoadingSpinner to fix VisualElement.transform becoming obsolete
- Fixed an issue in the Login process not allowing to retry
- Fixed some empty states that flickered when resizing the splitter or scrolling the table
- Fixed an issue provoked by the auto-refresh of the Pending changes view
- Fixed aesthetic shaking issue when the package view is re-dimensioned


## [2.8.2] - 2025-05-06

- Fixed false positive error showing in console if creating a workspace from the Hub with a version of the Unity Editor shipping with a default Version Control package older than version 2.7.1.

## [2.8.1] - 2025-04-29

### Added

- Added to the list of branches a context action to hide branches. You can use the filter to list the hidden branches and unhide them from the context menu.
- Added to the list of branches a context action to diff the branch.
- Added to the list of changesets a context action to create a new branch from a specific changeset.
- Added to the check-in and shelve notification a link to go to the list of changesets/shelves. The user can also copy the direct diff link.
- Added to the merge operation a notification with a link to go to the pending changes.
- Added to the undo and update workspace operations an ephemeral notification.
- Added to the status bar an action to copy to the clipboard the name of the current branch.
- Added to most dialogs an "Enter" keyboard shortcut to confirm the operation like the corresponding button.
- Added to the history of a folder a context action to revert changes.
- Added to the history a context action to diff changes for files that were moved/renamed.
- Added to the pending changes view the user avatar if available from Gravatar.
- Added to the merge view the avatars for authors of changes.

### Fixed

- Fixed the UI that could start refreshing forever, never completing the ongoing operations.
- Fixed the auto checkout for assets to only apply for file containing actual changes.
- Fixed project download from the Hub that was silently skipped when trying to download inside another workspace. It's now logging an explicit error in the console.
- Fixed a null exception that could occur when switching to the changesets tab very quickly after checkin.
- Fixed bulk editing meta files that was only performing a single checkout for the last element.
- Fixed a null exception that could occur on Revert to this revision if the selected change triggered a domain reload.
- Fixed the scroll that was not at the top when opening the branches or the shelves view.
- Fixed an error that was showing when deleting a shelveset that wasn't the one selected in the list.
- Fixed merge success notification that was showing in the view potentially colliding with contents.
- Implemented a mechanism to fix the path to UnityYAMLMerge.exe in the client.conf so it always points to an existing Unity installation.
- Fixed the apply shelve operation so that it checks for dirty changes and warn the user before applying the shelve.
- Fixed Undo changes of a Moved asset using the Asset Context Menu from the Project View that was leaving an inconsistent .meta file.
- Added the option to add a folder by path to the ignore or hidden changes list, instead of the incorrect option "Using the item extension".
- Fixed incorrect branch name in the history of a file for a revision where it was moved, displaying details of the move instead of the name of the branch.
- Fixed the Unity Editor crashing on macOS when opening the Unity Version Control window with the PiXYZ Plugin installed.
- Fixed a null exception that occured when using the diff search filter without any shelve in the repository.

## [2.7.1] - 2025-02-13

### Added

- Added a button to shelve selected pending changes. You can inspect the shelves content, and apply them to your workspace.
- Added the option to shelve pending changes when switching to another branch (or changeset). You can decide to apply them automatically after the switch.
- Added a context menu entry to create a code review from the list of branches (or changesets). You can decide to open the Desktop App or the Unity Cloud website.

### Changed

- Serialized the Checkin comment and tick selection so they are kept on any domain reload and play mode.
- Optimized incoming changes & merge to only reload the Package Manager when needed.
- Added dedicated toolbar buttons to open the list of branches and the Branch Explorer of the Desktop App.
- Reworded the changeset context menu "Undo this change" to "Revert this file to the previous revision" so it’s more explicit.
- Moved the 'Unity Version Control' menu item under 'Window'/'Version Control' submenu starting from Unity 6.1.
- Improve the Create workspace window to suggest the matching Unity Cloud project if it exists.

### Fixed

- Ensured ignore.conf is not being reformatted when adding or removing an ignore rule, so it keeps empty lines and comments.
- Fixed missing checked-out for renamed assets.
- Fixed rename asset leaves 'Added' + 'Remove locally' status instead of 'Moved'.
- Fixed console error GUI Error: Invalid GUILayout state in PlasticWindow view which is caused under some circumstances.
- Fixed null exception on entering in Play Mode before creating the workspace.
- Fixed lock statuses to correctly refresh in Project View and Inspector after merging.
- Fixed a performance issue by preventing the ConfigureLogging call on every domain reload when Unity Version Control is not used, reducing the load time by ~200ms. .
- Fixed the create branch operation to work in Gluon mode which uses partial workspaces.

## [2.6.0] - 2024-11-28

### Added

- Added the ability to merge a branch or a changeset, using a new context menu actions
- Added file conflict & dir conflict context menu actions to the merge view
- Added diff and merge settings in Project Settings -> Version Control -> Unity Version Control Settings
- Added merge options dialog to the merge view
- Added copy path & history context menu actions in all menus where they apply
- Added an menu entry to 'Open in Unity Cloud' showing the repository in the Unity Dashboard

### Changed

- Updated the minimum supported version to Unity 2021.3.0f1
- Removed support for migrating old Collaborate workspaces to Unity Version Control
- Hide from the public documentation all internal APIs that were previously visible by mistake
- Optimized switching operations to only triggers the Package Manager to reinstall packages when needed
- Optimized incoming changes to only reload the Package Manager when needed (Gluon/partial workspace only for now)
- Automatically add UnityDirMonSyncFile rule for existing ignore.conf to avoid triggering unnecessary finding changes operation
- Improved the “search” edit box so it can resize when there is not enough space in the toolbar
- Replaced the "D" DevOps icon by the branching icon used in the Hub
- Replaced the logo of Unity in the Sign in to Unity VCS window

### Fixed

- Fixed files getting checked out even though they are in hidden_changes.conf
- Fixed manual login to Cloud that didn't work with an Enterprise installation
- Fixed resolve conflicts not informing about lack of UVCS installation
- Fixed the Invite users to cloud organization when using an Enterprise installation
- Fixed new child branch not created from HEAD after update
- Fixed the learn more (here) link that showed the hex color value in Unity 6
- Fixed link to invite members in Unity Cloud.
- Fixed a crash in the create workspace window when unable to resolve a @unity organization
- Fixed incoming changes view that was not kept as selected after resolving some conflicts
- Fixed workspace name that was not refreshed after repository manual creation or selection
- Added a warning message to inform users about mismatching cloud project.
- Removed from the Create Workspace window the Local server that was present with no installation of UVCS
- Replaced hardcoded urls pointing to plasticscm.com

## [2.5.2] - 2024-09-25

### Fixed

- Fixed token renewal issue: Can't obtain a new token (Message: Invalid Refresh Token., Code: 132.104)
- Reworded labels in the Create Repository window and added a link to Create a new organization project.

## [2.5.1] - 2024-09-04

### Added

- Added support for the new @unity organizations
- Allow deletion of non-empty branches that have not been merged anywhere
- New setting to control if new files must be automatically added to source control

### Changed

- Improve the dialog to install Unity Version Control from the Editor

### Fixed

- Fixed 'an existing xxx operation has locked the workspace' error on finding changes operation
- Fixed a case of a hang happening on Editor quit
- Fixed the login that could fail for Enterprise installation
- Fixed undo operation that didn't capture changes in packages
- Fixed history that was not shown when there was no desktop client installed
- Fixed unity 6 Editor going into the background after a dialog was closed
- Fixed wrong font size when changing to changesets view
- Fixed the "Upgrade plan" button in Unity plugin that used a obsolete redirection link
- Fixed Logs that were configured too late in the initialization
- Fixed the minimum supported version (2020.3.48f1 LTS) in the README

## [2.4.4] - 2024-07-19

### Fixed

- Fixed the Unity Editor stuck on "Creating workspace" when "Use Unity Version Control" was selected from the Hub

## [2.4.3] - 2024-06-20

### Added

- Changed the default ignore.conf to not ignore itself
- Added "Undo unchanged" and "Undo checkouts keeping changes" options to pending changes view
- Removed focus redirection after Check-in

### Fixed

- Moving folders in the Editor now correctly use the UVCS "Move" operation
- Fixed hang on domain reload
- Fixed "item with the same key has already been added" error
- Fixed failure to delete a .meta file when deleting a private folder from the pending changes
- Supported workspace name with non-latin characters in Pending Changes
- Fixed text cut-off in filter rules dialog
- Fixed unexpected error while switching between branches
- Fixed error after renaming a parent branch of the working branch
- Fixed variables's value becoming clear after resolving conflict in inspector
- Removed misleading indication about shelves
- Fixed column sorting in pending changes view
- Fixed missing incoming changes after removing a branch
- Fixed "Collection was modified" error when doing multiple renames in a row
- Fixed undo & check-in operations not working when the current scene was never saved
- Fixed check in error if nothing is selected in the pending changes tree

## [2.3.1] - 2024-02-27

Unity Version Control is now available as part of the Version Control Package! You can enable Unity Version Control via Window > Unity Version Control to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:

- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added

- New view to list and manage locks.

### Fixed

- Fixed DropdownField not working properly on a ModalUtility window on MacOS.
- Fixed issue with existing checkout operations locking the workspace.
- Reviewed initialization and application lifecycle.
- Fixed layout error when switching checkout status in the inspector.
- Fixed Diff option unavailable for .prefab.
- Fixed UI error when opening and closing multiple closable tabs.
- Ensured branch creations start from the latest changeset.
- Unable to expand added item list after collapsing.
- Pending Changes context menu had the view file history greyed out for asset+meta.
- Preconfigured date format was not recognized as a valid DateTime.
- Fixed finding changes operation being firing constantly.
- Removed obsolete content in package documentation.
- Fixed typo in locks tooltip.
- Replaced the text "plasticscm.com" by a https://unity.com/solutions/version-control in the package.json

## [2.2.0] - 2023-10-06

Unity Version Control is now available as part of the Version Control Package! You can enable Unity Version Control via Window > Unity Version Control to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:

- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added

- Added button for organization owner/admins to upgrade to DevOps subscription.
- Included new decorators for retained & locked files.

### Changed

- Updated description in the package.json, including an updated link to get started.

### Fixed

- Fixed failed operations when the workspace is already locked.

## [2.1.0] - 2023-09-01

Unity Version Control is now available as part of the Version Control Package! You can enable Unity Version Control via Window > Unity Version Control to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:

- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added

- Added command to support Hub creating a new project, and connecting a project to Unity Version Control.
- Show a message with a link to invite users to the organization after the first checkin.

### Changed

- Moved the button to invite users to the organization from the submenu to the toolbar.

### Removed

- Don't write cloudProjectId in ProjectSettings.asset anymore since it should only be managed by Services.

### Fixed

- Fixed Add to ignored/hidden changes list from the Project window creating a negative rule.
- Fixed Switch to changeset not working on Gluon partial workspace.

## [2.0.7] - 2023-07-25

Unity Version Control is now available as part of the Version Control Package! You can enable Unity Version Control via Window > Unity Version Control to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:

- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Fixed

- Fixed the Unity Version Control icon disappearing from the Editor Toolbar on domain reload.
- Fixed the popup stating "An existing checkout operation has locked the workspace" when trying to check in a scene with unsaved changes.

## [2.0.5] - 2023-05-31

Unity Version Control is now available as part of the Version Control Package! You can enable Unity Version Control via Window > Unity Version Control to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:

- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Fixed

- Fixed remaining references to 'Plastic SCM' in localized labels.

## [2.0.4] - 2023-04-14

Unity Version Control is now available as part of the Version Control Package! You can enable Unity Version Control via Window > Unity Version Control to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Fixed
- Fixed 'Texture2D' does not contain a definition for 'ignoreMipmapLimit' error when installing Unity Version Control on previous Unity Editor Versions
- Fixed broken sign in dialog style when waiting for user to complete sign in
- Fixed NullReferenceException when opening a new project and the user doesn't have a Unity Version Control organization linked to a Unity ID

## [2.0.3] - 2023-03-29

Unity Version Control is now available as part of the Version Control Package! You can enable Unity Version Control via Window > Unity Version Control to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Changed
- Changed the icons for Unity Version Control rebranding
- Changed onboarding workflow

### Fixed
- Fixed blurry icons in the Unity Version Control window and toolbar button
- Fixed Pending Changes tab not always opening its selected item's location in Project window
- Fixed "Checked-out (changed)" status icon not showing up on Pending Changes tab
- Fixed issue that prevented new packages from being installed unless user enters play mode

## [2.0.1] - 2023-02-17

Unity Version Control is now available as part of the Version Control Package! You can enable Unity Version Control via Window > Unity Version Control to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Changed
- Updated branding from "Plastic SCM" to "Unity Version Control"
- Improved offline experience by disabling the plugin when there is no internet connection

## [2.0.0] - 2023-01-11

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Changed
- Removed Collab from the package

## [1.17.7] - 2022-10-28

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added offline mode toggle for smoother offline experience

### Fixed
- Fixed performance issue with FindWorkspaceForPath method called multiple times every frame
- Fixed performance issue with UI.CooldownWindowDelayer.OnUpdate running on project without Plastic SCM workspace

## [1.17.6] - 2022-10-06

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Changed
- Changed the "Go back to changeset" option in Changesets tab to "Revert to changeset"
- Improved notification banner appearance

### Fixed
- Fixed editor refresh triggering when a workspace update is in progress
- Fixed pending changes show global ignored as private
- Removed encryption checkbox from create organization dialog

## [1.17.2] - 2022-07-06

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added notification banner on the status bar for live updates

### Changed
- Renamed "Invite members to workspace" option to "Invite members to organization"

### Fixed
- Fixed not being able to view changesets in a Gluon workspace
- Fixed not being able to insert carriage return in checkin dialog

## [1.17.1] - 2022-06-21

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Fixed
- Fixed missing references in synced prefabs

## [1.17.0] - 2022-06-13

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added option to enable changelists and display them in pending changes tab
- Added changelist related options to pending changes context menu

### Fixed
- Fixed editor hangs when there is no network available
- Fixed existing checkout has locked the workspace error
- Fixed checkin fails over unstable connection

## [1.15.18] - 2022-05-18

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Fixed
- Fixed editor hang when entering Play Mode

## [1.15.17] - 2022-04-27

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added checkin comment column to Incoming Changes view

### Changed
- Updated Go Back confirmation message to be consistent with feature
- Updated Create Child Branch dialog to focus on branch name field when opened
- Improved messaging of Subtractive Merge after using Go Back feature

### Fixed
- Fixed assets not added correctly when Plastic SCM window is not open
- Fixed wrong position of overlay icons on Pending Changes view
- Disallowed Go Back feature to a changeset from another branch

## [1.15.16] - 2022-03-28

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added "Switch to changeset" menu option in changesets view
- Added "Go back to changeset" menu option in changesets view

### Changed
- Removed category icons from views
- Removed "com.unity.services.core" package dependency

### Fixed
- Fixed light theme icons used in dark theme after pulling incoming changes
- Fixed "Input string was not in a correct format" error

## [1.15.15] - 2022-03-09

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added checkout option in scene prefab view

### Changed
- Updated file overlay icon size to adapt to project window zoom level
- Updated the styling of number of items in a category in Gluon incoming changes view

### Fixed
- Fixed Plastic X not opening from plugin menu
- Fixed error when trying to invite members to proect
- Fixed editor unhandled errors being hijacked by the plugin
- Fixed toolbar icon not displaying incoming changes notification when Plastic window is closed
- Fixed VCCache::instance != NULL error when opening a project with Plastic window opened

## [1.15.13] - 2022-02-14

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added branch name column in changeset view

### Changed
- Updated checkin comment box to keep the last comment after checkin error

### Fixed
- Fixed performance regression in large projects due to FindObjectsOfTypeAll calls

## [1.15.12] - 2022-01-27

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added option to "Save Revision as" to the context menu in the changesets view
- Added incoming changes overview bar for Gluon workspace

### Changed
- Updated the styling for number of items in category for pending changes view
- Updated the styling for number of items in category for changesets view
- Updated the styling for tabs close button
- Updated the color in different sections of the plugin
- Reduced dialog padding for the "Create Branch" dialog
- Updated the display overlay icons to show even if PlasticSCM window is closed
- Updated styling of number of items in incoming changes category
- Improved plugin initialization process and let the plugin functions without needing the Plastic window opened
- Disabled the invite button when user does not have invite permission or not on a cloud repo

### Fixed
- Fixed size info in incoming changes view does not match actual changes size
- Fixed checkin and checkout options not respecting inspector locked status
- Fixed buttons in inspector view displayed even when Plastic window is closed
- Fixed icon incorrect sizes
- Fixed errors on create branch dialog
- Fixed Newtonsoft.Json.dll conflicts with other external packages
- Fixed editor objects count increasing when hovering over Plastic window or toolbar button
- Fixed ArgumentOutOfRange exception when creating a branch
- Fixed scene reloading not happening after creating a new branch

## [1.15.7] - 2021-12-02

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added option to "Save Revision as" to the context menu in the changesets view
- Added incoming changes overview bar for Gluon workspace

### Changed
- Moved Plastic Package settings to the Unity Project Settings window
- Refined styling for Updating Workplace success state
- Updated texts for empty state and overview bar
- Removed Incoming Changes notification from empty state
- Updated the text for Forced Checkout option
- Refined the status overlay icons
- Updated the refresh icon on the toolbar
- Updated the texts for empty checkin message dialog

### Fixed
- Fixed capitalization of Pending Changes and File History tab names
- Fixed the amount of spacing after the Item column title in the Pending Changes tab
- Removed pin striping from line items in File History tab
- Fixed project view context menu and icons missing after Collaborate project migration
- Fixed migrated projects not downloading correctly from Unity Hub

## [1.15.4] - 2021-11-10

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Add option to "Add to ignore file" in context menu in the project view
- Added empty state message for Pending Changes tab
- Added success state message for Pending Changes tab
- Added metrics for Branches tab functionalities

### Changed
- Removed pinstriping in the Gluon Incoming Changes window
- Removed the “Nothing to download” bar from the Incoming Changes window when there are no items to download
- Changed the default metadata columns shown in the Incoming Changes screen
- Updated the alignment of sorting arrows to the right of the column

### Fixed
- Fixed UI overlays in Project view missing on changed assets when force checkout is disabled
- Fixed console error when selecting object in Scene view hierarchy or creating a new asset
- Fixed NullReferenceException after closing the Plastic SCM window

## [1.15.1] - 2021-10-21

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added visual overview bar to the incoming changes tab
- Added progress dialog for the migration process
- Added Branches tab that shows a list of all branches in the repository
- Added option and dialog to create a child branch from selected branch.
- Added option to switch to another branch
- Added option and dialog to rename a branch
- Added option to delete a branch
- Added a preference to save if the window should open the Branches tab by default
- Added metrics for Plastic SCM installation window usage

### Changed
- Updated texts for workspace modes selection and checkin comment box
- Updated status bar notification icons

### Fixed
- Fixed inverted text for the force checkout option
- Fixed typing capital O in checkin comment would open the selected item
- Fixed loading indicator not centered on Plastic SCM installation window
- Fixed installing Plastic SCM would sign out user from the plugin
- Removed extra refresh button on Gluon's Incoming Changes tab
- Fixed loading indicator not centered on Plastic SCM installation window
- Fixed missing Plastic SCM window option when user is not signed in on Unity Hub
- Removed meta file warning message for the deleted Beta folder
- Fixed Plastic SCM menu missing from Project view context menu

## [1.13.5] - 2021-09-27

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added workspace migration from Collab to Plastic which can be done with or without Plastic installed
- Added notification status icons
- Added light and dark mode versions of avatar icon

### Changed
- Updated texts for migration
- Improved usage analytics around Editor and Plugin version
- Workspace Migration Adjustments

### Fixed
- Renamed the CoreServices namespace so it doesn't conflict with other packages
- Devex integration to properly depend on Core
- Fixed some situations where the history window would be blank
- Fixed missing Enterprise login link
- Fixed low resolution icons in light theme

## [1.11.2] - 2021-08-27

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added horizontal scroll bar to Changesets list for easier viewing
- Added auto-login for SSO credentials handler
- Added metrics for changeset tab usage
- Added metrics for checkin actions
- Added new Undo icon
- Added missing API documentation
- Added ability to modify assets without checkout
- Added ability to allow empty checkin messages
- Added empty checking message localization
- Added Plastic toolbar button to Unity editor
- Added notification icon for incoming changes to Plastic toolbar button

### Changed
- Removed the unneeded refresh button from History Tab
- Moved search bar to the top right global icon section in all tabs
- Updated capitalization of options in the Settings context menu
- Updated tab button styling to be consistent with Unity Editor conventions
- Status bar visible across all tabs
- Moved refresh button to the toolbar at the top right corner of the window
- Moved changesets time period selector to the right corner of the window
- Removed "Changes of changeset" header on the Changesets tab
- Moved number of selected items next to "Item" metadata title on the Pending Changes tab
- Improved refresh icon resolution
- Changed changesets detail to appear in vertical column
- Reduced default number of columns in changesets tab
- The number of changesets is no longer displayed in changesets tab
- Changed Launch branch explorer into an icon with tooltip
- Removed the hide changes button in changesets tab
- Moved incoming change prompt and button into a status bar
- Changed "Launch Plastic" to "Launch Plastic SCM" in options menu
- Wording change for plastic installation
- Updated file status icons

### Fixed
- Fixed a bug where the Texture2D error would pop up after downloading a project
- Fixed a bug when context menu would sometimes disappear
- Fixed small textbox on checkin dialog when launched from context menu
- Fixed a workspace NullReferenceException bug
- Fixed notification icon not showing on Plastic window
- Fixed auto login errors not showing up for users
- Fixed unexpected error message after user switched workspace to a label

## [1.9.0] - 2021-07-13

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.

### Added
- Added Checkin and Update confirmation notification
- Added auto sign in when logged into Unity account

### Changed
- Simplified UI: decluttered UI
- Improved load time performance

### Fixed
- Fixed view not switching to workspace after creating an Enterprise Gluon workspace
- Fixed contextual menu not showing up in project view
- Fixed SSO renew token after password change
- Fixed some namespace collisions with Antlr3

## [1.7.1] - 2021-06-25

Plastic SCM for Unity is now available as part of the Version Control Package! You can enable Plastic SCM via Window > Plastic SCM to get started!
If you have previously used the Unity Asset Store Plastic SCM plug-in, you can now simply use this package. Make sure you delete the plug-in from your project.
Removing a previously added Plastic SCM Asset Store Plug-In:
- Select the PlasticSCM folder in the Assets\Plugins folder on the Project tab, then click Edit > Delete
- Close the Unity Editor and open your project again. You will find the Plastic SCM menu item in the Window menu.
### Added
- Added support for inviting other members. This option is available from the gear / settings icon.
- Added support for signing in with Cloud Edition. This is available during the onboarding screen if you have never signed in.
- Added support for turning off Plastic in their project. This option removes the Plastic metadata from your directory. This option is available under Assets > Plastic SCM > Turn off Plastic SCM
- Added notification on the Plastic SCM tab title to indicate incoming changes. Users will no longer need to have the Plastic SCM window visible to know there are incoming changes.
- Auto configuration of SSO
- Added date column in incoming changes
### Changed
- Updating license to better conform with expected customer usage.
- Updated documentation file to meet standards.
- Updated third-party usage.
- No longer requires downloading of the full Plastic client. Basic features will work without additional installation. Features that require the full Plastic client will allow download and install as needed.
- Usability improvements around checking in code
- Improved update workspace tab UX
- Plastic SCM context menu is now available even if the Plastic SCM window is closed
### Fixed
- Stability and performance improvements

## [1.5.7] - 2021-04-07
### Unreleased
- The Version Control package will be expanding to include both Collaborate and Plastic SCM version control interfaces. This release is preparing for that move and contains no new functionality or bug fixes for Collaborate.
### Changed
- Collaborate Package renamed to Version Control with changes to package display name and description.
### Fixed
- Fixed NPE when updating the version of the Collab package.

## [1.3.9] - 2020-07-13
### Fixed
- Unnecessary use of texture compression in icons that slowed down platform switching
- Update publish button state when selected changes update
- Use colorized icons when changes are available.

## [1.3.8] - 2020-06-08
### Fixed
- Fix incorrect priority of error messages
- Fix Collab button being stuck in inprogress state
- Fix error when partially publishing without the window open

## [1.3.7] - 2020-01-30
### Changed
- Bulk revert is now supported.
- Collab is blocked in play mode.
### Fixed
- Fixed services window's links to open Collab.

## [1.3.6] - 2020-01-21
### Fixed
- Fixed compile errors when removing the NUnit package by removing unnecessary references.

## [1.3.5] - 2020-01-08
### Fixed
- Fix "accept mine" / "accept remote" icon swap in conflicts view.

## [1.3.4] - 2019-12-16
### Changed
- Window state is no longer restored after the window is closed and opened.
### Fixed
- History tab failing to load on startup if it is left open in the previous session.
- Progress bar percentage not matching the bar.
- History list correctly updates after a new revision is published.
- UI instabilities when restoring or going back to a revision with a different package manifest.
- Improve handling of changes to the project id.

## [1.3.3] - 2019-12-10
### Changed
- Disable UI test cases that can be unstable.

## [1.3.2] - 2019-12-05
### Changed
- Update UX to UIElements.
- Increased minimum supported version to 2020.1.
- Update Documentation to required standards.

## [1.2.16] - 2019-02-11
### Fixed
- Update stylesheet to pass USS validation

## [1.2.15] - 2018-11-16
### Changed
- Added support for non-experimental UIElements.

## [1.2.11] - 2018-09-04
### Fixed
- Made some performance improvements to reduce impact on ReloadAssemblies.

## [1.2.9] - 2018-08-13
### Fixed
- Test issues for the Collab History Window are now fixed.

## [1.2.7] - 2018-08-07
### Fixed
- Toolbar drop-down will no longer show up when package is uninstalled.

## [1.2.6] - 2018-06-15
### Fixed
- Fixed an issue where Collab's History window wouldn't load properly.

## [1.2.5] - 2018-05-21
This is the first release of *Unity Package CollabProxy*.

### Added
- Collab history and toolbar windows
- Collab view and presenter classes
- Collab Editor tests for view and presenter
