# Node library

Explore nodes that enable color and channel manipulation, mathematical and procedural generation, input data handling, custom texture management, UV mapping, utility logic, and shader data representation.

## Graph nodes

| **Topic**                                                     | **Description**                                                                                                                              |
|:--------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------|
| [Artistic](Artistic-Nodes.md)                                 | Learn about color adjustment, blending, filtering, masking, normal map manipulation, and color space conversion.                             |
| [Channel](Channel-Nodes.md)                                   | Learn about combining, splitting, reordering, or flipping vector and color channels. |
| [Custom Render Texture nodes](Custom-Render-Texture-Nodes.md) | Learn about properties and data of custom render textures.                           |
| [Input](Input-Nodes.md)                                       | Learn about values, mesh attributes, gradients, matrices, deformation data, PBR parameters, scene information, and texture sampling options. |
| [Math](Math-Nodes.md)                                         | Learn about mathematical operations.                                                 |
| [Procedural](Procedural-Nodes.md)                             | Learn about creating patterns, noise textures, and geometric shapes.                                                                         |
| [Utility](Utility-Nodes.md)                                   | Learn about basic preview, sub-graph referencing, and essential logic operations.    |
| [UV](UV-Nodes.md)                                             | Learn about manipulation and mapping effects, enabling advanced texture animations, coordinate transformations, and warping techniques.      |

## Block nodes

| **Topic**                      | **Description**                                                                           |
|:-------------------------------|-------------------------------------------------------------------------------------------|
| [Block](Block-Node.md)         | You can find these nodes in the **Vertex** and **Fragment** contexts of the Master Stack. |

## Additional resources

* [Node](Node.md)
* [Create Node Menu](Create-Node-Menu.md)
* [Shader Graph Node Reference Samples](ShaderGraph-Samples.md)

