* [About Shader Graph](index.md)
* [What's new in Shader Graph](whats-new.md)
* [Install and upgrade](install-and-upgrade.md)
    * [Install Shader Graph](install-shader-graph.md)
    * [Upgrade to Shader Graph 10.0.x](Upgrade-Guide-10-0-x.md)
* [Get started with Shader Graph](Getting-Started.md)
    * [Creating a new Shader Graph Asset](Create-Shader-Graph.md)
    * [My first Shader Graph](First-Shader-Graph.md)
* [Shader Graph UI reference](ui-reference.md)
    * [Shader Graph Window](Shader-Graph-Window.md)
        * [Blackboard](Blackboard.md)
        * [Main Preview](Main-Preview.md)
        * [Graph Inspector](Internal-Inspector.md)
    * [Create Node Menu](Create-Node-Menu.md)
    * [Graph Settings Tab](Graph-Settings-Tab.md)
    * [Master Stack](Master-Stack.md)
    * [Shader Graph Preferences](Shader-Graph-Preferences.md)
    * [Shader Graph Project Settings](Shader-Graph-Project-Settings.md)
    * [Shader Graph Keyboard Shortcuts](Keyboard-shortcuts.md)
* [Inside Shader Graph](inside-shader-graph.md)
    * [Shader Graph Asset](Shader-Graph-Asset.md)
    * [Graph Target](Graph-Target.md)
    * [Node](Node.md)
        * [Port](Port.md)
        * [Custom Port Menu](Custom-Port-Menu.md)
        * [Edge](Edge.md)
    * [Sub Graph](Sub-graph.md)
    * [Sub Graph Asset](Sub-graph-Asset.md)
        * [SpeedTree 8 Sub Graph Assets](SpeedTree8-SubGraphAssets.md)
    * [Sticky Notes](Sticky-Notes.md)
    * [Color Modes](Color-Modes.md)
    * [Precision Modes](Precision-Modes.md)
    * [Preview Mode Control](Preview-Mode-Control.md)
    * [Custom Render Textures](Custom-Render-Texture.md)
        * [Accessing](Custom-Render-Texture-Accessing.md)
        * [Example](Custom-Render-Texture-Example.md)
    * [Material Variants](materialvariant-SG.md)
    * [Property Types](Property-Types.md)
    * [Keywords](Keywords.md)
        * [Introduction to keywords](Keywords-concepts.md)
        * [Manage keywords](Keywords-manage.md)
        * [Keyword parameter reference](Keywords-reference.md)
    * [Data Types](Data-Types.md)
    * [Port Bindings](Port-Bindings.md)
    * [Shader Stage](Shader-Stage.md)
    * [Surface options](surface-options.md)
    * [Custom Interpolators](Custom-Interpolators.md)
* [Node Library](Node-Library.md)
    * [Artistic](Artistic-Nodes.md)
        * Adjustment
            * [Channel Mixer](Channel-Mixer-Node.md)
            * [Contrast](Contrast-Node.md)
            * [Hue](Hue-Node.md)
            * [Invert Colors](Invert-Colors-Node.md)
            * [Replace Color](Replace-Color-Node.md)
            * [Saturation](Saturation-Node.md)
            * [White Balance](White-Balance-Node.md)
        * Blend
            * [Blend](Blend-Node.md)
        * Filter
            * [Dither](Dither-Node.md)
            * [Fade Transition](Fade-Transition-Node.md)
        * Mask
            * [Channel Mask](Channel-Mask-Node.md)
            * [Color Mask](Color-Mask-Node.md)
        * Normal
            * [Normal Blend](Normal-Blend-Node.md)
            * [Normal From Height](Normal-From-Height-Node.md)
            * [Normal From Texture](Normal-From-Texture-Node.md)
            * [Normal Reconstruct Z](Normal-Reconstruct-Z-Node.md)
            * [Normal Strength](Normal-Strength-Node.md)
            * [Normal Unpack](Normal-Unpack-Node.md)
        * Utility
            * [Colorspace Conversion](Colorspace-Conversion-Node.md)
    * [Channel](Channel-Nodes.md)
        * [Append](Append-Node.md)
        * [Combine](Combine-Node.md)
        * [Flip](Flip-Node.md)
        * [Split](Split-Node.md)
        * [Swizzle](Swizzle-Node.md)
    * [Custom Render Texture Nodes](Custom-Render-Texture-Nodes.md)
        * [Self](Custom-Texture-Self.md)
        * [Size](Custom-Texture-Size.md)
        * [Slice](Custom-Texture-Slice.md)
    * [Input](Input-Nodes.md)
        * Basic
            * [Boolean](Boolean-Node.md)
            * [Color](Color-Node.md)
            * [Constant](Constant-Node.md)
            * [Integer](Integer-Node.md)
            * [Slider](Slider-Node.md)
            * [Time](Time-Node.md)
            * [Float](Float.md)
            * [Vector 2](Vector-2-Node.md)
            * [Vector 3](Vector-3-Node.md)
            * [Vector 4](Vector-4-Node.md)
        * Geometry
            * [Bitangent Vector](Bitangent-Vector-Node.md)
            * [Instance ID](Instance-ID-Node.md)
            * [Normal Vector](Normal-Vector-Node.md)
            * [Position](Position-Node.md)
            * [Screen Position](Screen-Position-Node.md)
            * [Tangent Vector](Tangent-Vector-Node.md)
            * [UV](UV-Node.md)
            * [Vertex Color](Vertex-Color-Node.md)
            * [Vertex ID](Vertex-ID-Node.md)
            * [View Direction](View-Direction-Node.md)
            * [View Vector](View-Vector-Node.md)
        * Gradient
            * [Blackbody](Blackbody-Node.md)
            * [Gradient](Gradient-Node.md)
            * [Sample Gradient](Sample-Gradient-Node.md)
        * High Definition Render Pipeline
            * [Custom Color Buffer](HD-Custom-Color-Node.md)
            * [Custom Depth Buffer](HD-Custom-Depth-Node.md)
            * [Diffusion Profile](Diffusion-Profile-Node.md)
            * [Exposure](Exposure-Node.md)
            * [HD Scene Color](HD-Scene-Color-Node.md)
            * [HD Scene Depth](HD-Scene-Depth-Node.md)
            * [HD Sample Buffer](HD-Sample-Buffer-Node.md)
        * Lighting
            * [Ambient](Ambient-Node.md)
            * [Baked GI](Baked-GI-Node.md)
            * [Main Light Direction](https://docs.unity3d.com/Packages/com.unity.shadergraph@13.1/manual/Main-Light-Direction-Node.html)
            * [Reflection Probe](Reflection-Probe-Node.md)
        * Matrix
            * [Matrix 2x2](Matrix-2x2-Node.md)
            * [Matrix 3x3](Matrix-3x3-Node.md)
            * [Matrix 4x4](Matrix-4x4-Node.md)
            * [Transformation Matrix](Transformation-Matrix-Node.md)
        * Mesh Deformation
          * [Compute Deformation](Compute-Deformation-Node.md)
          * [Linear Blend Skinning](Linear-Blend-Skinning-Node.md)
        * Sprite Deformation
          * [Sprite Skinning](Sprite-Skinning-Node.md)
        * PBR
            * [Dielectric Specular](Dielectric-Specular-Node.md)
            * [Metal Reflectance](Metal-Reflectance-Node.md)
            * [Fresnel Equation](Fresnel-Equation-Node.md)
        * Scene
            * [Camera](Camera-Node.md)
            * [Eye Index](Eye-Index-Node.md)
            * [Fog](Fog-Node.md)
            * [Object](Object-Node.md)
            * [Scene Color](Scene-Color-Node.md)
            * [Scene Depth](Scene-Depth-Node.md)
            * [Scene Depth Difference](Scene-Depth-Difference-Node.md)
            * [Screen](Screen-Node.md)
        * Texture
            * [Calculate Level Of Detail Texture 2D Node](Calculate-Level-Of-Detail-Texture-2D-Node.md)
            * [Cubemap Asset](Cubemap-Asset-Node.md)
            * [Gather Texture 2D Node](Gather-Texture-2D-Node.md)
            * [Sample Cubemap](Sample-Cubemap-Node.md)
            * [Sample Reflected Cubemap](Sample-Reflected-Cubemap-Node.md)
            * [Sample Texture 2D](Sample-Texture-2D-Node.md)
            * [Sample Texture 2D Array](Sample-Texture-2D-Array-Node.md)
            * [Sample Texture 2D LOD](Sample-Texture-2D-LOD-Node.md)
            * [Sample Texture 3D](Sample-Texture-3D-Node.md)
            * [Sample Virtual Texture](Sample-Virtual-Texture-Node.md)
            * [Sampler State](Sampler-State-Node.md)
            * [Split Texture Transform](Split-Texture-Transform-Node.md)
            * [Texture 2D Array Asset](Texture-2D-Array-Asset-Node.md)
            * [Texture 2D Asset](Texture-2D-Asset-Node.md)
            * [Texture 3D Asset](Texture-3D-Asset-Node.md)
            * [Texture Size](Texture-Size-Node.md)
    * [Math](Math-Nodes.md)
        * Advanced
            * [Absolute](Absolute-Node.md)
            * [Exponential](Exponential-Node.md)
            * [Length](Length-Node.md)
            * [Log](Log-Node.md)
            * [Modulo](Modulo-Node.md)
            * [Negate](Negate-Node.md)
            * [Normalize](Normalize-Node.md)
            * [Posterize](Posterize-Node.md)
            * [Reciprocal](Reciprocal-Node.md)
            * [Reciprocal Square Root](Reciprocal-Square-Root-Node.md)
        * Basic
            * [Add](Add-Node.md)
            * [Divide](Divide-Node.md)
            * [Multiply](Multiply-Node.md)
            * [Power](Power-Node.md)
            * [Square Root](Square-Root-Node.md)
            * [Subtract](Subtract-Node.md)
        * Derivative
            * [DDX](DDX-Node.md)
            * [DDXY](DDXY-Node.md)
            * [DDY](DDY-Node.md)
        * Interpolation
            * [Inverse Lerp](Inverse-Lerp-Node.md)
            * [Lerp](Lerp-Node.md)
            * [Smoothstep](Smoothstep-Node.md)
        * Matrix
            * [Matrix Construction](Matrix-Construction-Node.md)
            * [Matrix Determinant](Matrix-Determinant-Node.md)
            * [Matrix Split](Matrix-Split-Node.md)
            * [Matrix Transpose](Matrix-Transpose-Node.md)
        * Range
            * [Clamp](Clamp-Node.md)
            * [Fraction](Fraction-Node.md)
            * [Maximum](Maximum-Node.md)
            * [Minimum](Minimum-Node.md)
            * [One Minus](One-Minus-Node.md)
            * [Random Range](Random-Range-Node.md)
            * [Remap](Remap-Node.md)
            * [Saturate](Saturate-Node.md)
        * Round
            * [Ceiling](Ceiling-Node.md)
            * [Floor](Floor-Node.md)
            * [Round](Round-Node.md)
            * [Sign](Sign-Node.md)
            * [Step](Step-Node.md)
            * [Truncate](Truncate-Node.md)
        * Trigonometry
            * [Arccosine](Arccosine-Node.md)
            * [Arcsine](Arcsine-Node.md)
            * [Arctangent](Arctangent-Node.md)
            * [Arctangent2](Arctangent2-Node.md)
            * [Cosine](Cosine-Node.md)
            * [Degrees To Radians](Degrees-To-Radians-Node.md)
            * [Hyperbolic Cosine](Hyperbolic-Cosine-Node.md)
            * [Hyperbolic Sine](Hyperbolic-Sine-Node.md)
            * [Hyperbolic Tangent](Hyperbolic-Tangent-Node.md)
            * [Radians To Degrees](Radians-To-Degrees-Node.md)
            * [Sine](Sine-Node.md)
            * [Tangent](Tangent-Node.md)
        * Vector
            * [Cross Product](Cross-Product-Node.md)
            * [Distance](Distance-Node.md)
            * [Dot Product](Dot-Product-Node.md)
            * [Fresnel Effect](Fresnel-Effect-Node.md)
            * [Projection](Projection-Node.md)
            * [Reflection](Reflection-Node.md)
            * [Refract](Refract-Node.md)
            * [Rejection](Rejection-Node.md)
            * [Rotate About Axis](Rotate-About-Axis-Node.md)
            * [Sphere Mask](Sphere-Mask-Node.md)
            * [Transform](Transform-Node.md)
        * Wave
            * [Noise Sine Wave](Noise-Sine-Wave-Node.md)
            * [Sawtooth Wave](Sawtooth-Wave-Node.md)
            * [Square Wave](Square-Wave-Node.md)
            * [Triangle Wave](Triangle-Wave-Node.md)
    * [Procedural](Procedural-Nodes.md)
        * Noise
            * [Gradient Noise](Gradient-Noise-Node.md)
            * [Simple Noise](Simple-Noise-Node.md)
            * [Voronoi](Voronoi-Node.md)
        * Shapes
            * [Ellipse](Ellipse-Node.md)
            * [Polygon](Polygon-Node.md)
            * [Rectangle](Rectangle-Node.md)
            * [Rounded Polygon](Rounded-Polygon-Node.md)
            * [Rounded Rectangle](Rounded-Rectangle-Node.md)
        * [Checkerboard](Checkerboard-Node.md)
    * [Utility](Utility-Nodes.md)
        * Logic
            * [All](All-Node.md)
            * [And](And-Node.md)
            * [Any](Any-Node.md)
            * [Branch](Branch-Node.md)
            * [Branch On Input Connection](Branch-On-Input-Connection-Node.md)
            * [Comparison](Comparison-Node.md)
            * [Is Front Face](Is-Front-Face-Node.md)
            * [Is Infinite](Is-Infinite-Node.md)
            * [Is NaN](Is-NaN-Node.md)
            * [Nand](Nand-Node.md)
            * [Not](Not-Node.md)
            * [Or](Or-Node.md)
        * High Definition Render Pipeline
            * [Emission](Emission-Node.md)
            * Eye
              * [CirclePupilAnimation](Circle-Pupil-Animation-Node.md)
              * [CorneaRefraction](Cornea-Refraction-Node.md)
              * [EyeSurfaceTypeDebug](Eye-Surface-Type-Debug-Node.md)
              * [IrisLimbalRing](Iris-Limbal-Ring-Node.md)
              * [IrisOffset](Iris-Offset-Node.md)
              * [IrisOutOfBoundColorClamp](Iris-Out-Of-Bound-Color-Clamp-Node.md)
              * [IrisUVLocation](Iris-UV-Location-Node.md)
              * [ScleraIrisBlend](Sclera-Iris-Blend-Node.md)
              * [ScleraLimbalRing](Sclera-Limbal-Ring-Node.md)
              * [ScleraUVLocation](Sclera-UV-Location-Node.md)
            * Fabric
                *[ThreadMapDetail](ThreadMapDetail-Node.md)
            * [UVCombine](UVCombine-Node.md)
        * [Custom Function](Custom-Function-Node.md)
        * [Keyword](Keyword-Node.md)
        * [Preview](Preview-Node.md)
        * [Subgraph](Sub-graph-Node.md)
        * [Subgraph Dropdown node](Sub-Graph-Dropdown-Node.md)
    * [UV](UV-Nodes.md)
        * [Flipbook](Flipbook-Node.md)
        * [Polar Coordinates](Polar-Coordinates-Node.md)
        * [Radial Shear](Radial-Shear-Node.md)
        * [Rotate](Rotate-Node.md)
        * [Spherize](Spherize-Node.md)
        * [Tiling And Offset](Tiling-And-Offset-Node.md)
        * [Triplanar](Triplanar-Node.md)
        * [Twirl](Twirl-Node.md)
        * [Parallax Mapping](Parallax-Mapping-Node.md)
        * [Parallax Occlusion Mapping](Parallax-Occlusion-Mapping-Node.md)
    * [Block Nodes](Block-Node.md)
      * [Built In Blocks](Built-In-Blocks.md)
* [Samples](ShaderGraph-Samples.md)
    * [Feature Examples](Shader-Graph-Sample-Feature-Examples.md)
    * [Production Ready Shaders](Shader-Graph-Sample-Production-Ready.md)
        * [Lit Shaders](Shader-Graph-Sample-Production-Ready-Lit.md)
        * [Decal shaders](Shader-Graph-Sample-Production-Ready-Decal.md)
        * [Detail shaders](Shader-Graph-Sample-Production-Ready-Detail.md)
        * [Rock shaders](Shader-Graph-Sample-Production-Ready-Rock.md)
        * [Water shaders](Shader-Graph-Sample-Production-Ready-Water.md)
        * [Post-process shaders](Shader-Graph-Sample-Production-Ready-Post.md)
        * [Weather shaders](Shader-Graph-Sample-Production-Ready-Weather.md)
        * [Miscellaneous shaders](Shader-Graph-Sample-Production-Ready-Misc.md)
        * [Forest Stream Construction Tutorial ](Shader-Graph-Sample-Production-Ready-Tutorial.md) 
    * [UGUI Shaders](Shader-Graph-Sample-UGUI-Shaders.md) 
        * [Getting started](Shader-Graph-Sample-UGUI-Shaders-Getting-Started.md)
        * [Custom UI components](Shader-Graph-Sample-UGUI-Shaders-Custom-UI-components.md)
        * [Custom nodes](Shader-Graph-Sample-UGUI-Shaders-Custom-nodes.md)
        * [Subgraph nodes](Shader-Graph-Sample-UGUI-Shaders-Subgraph-nodes.md)
        * [Examples](Shader-Graph-Sample-UGUI-Shaders-Examples.md)
        * [How tos](Shader-Graph-Sample-UGUI-Shaders-How-tos.md)
            * [How to create a resolution-independent shape](Shader-Graph-Sample-UGUI-Shaders-How-tos-Res-indepenent.md)
            * [How to create a functioning button](Shader-Graph-Sample-UGUI-Shaders-How-tos-Button.md)
            * [How to make shapes that adapt to the aspect ratio of the UI element](Shader-Graph-Sample-UGUI-Shaders-How-tos-aspect-ratio.md)
        * [Notes on performance](Shader-Graph-Sample-UGUI-Shaders-Notes-on-performance.md)
