# UV nodes

Create texture animations, coordinate transformations, and warping through UV manipulation and mapping effects.

| **Topic**                                                        | **Description**                                                                                                 |
|------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------|
| [Flipbook](Flipbook-Node.md)                                     | Creates a flipbook, or texture sheet animation, of the UVs supplied to input In.                                |
| [Radial Shear](Radial-Shear-Node.md)                             | Applies a radial shear warping effect similar to a wave to the value of input UV.                               |
| [Spherize](Spherize-Node.md)                                     | Applies a spherical warping effect similar to a fisheye camera lens to the value of input UV.                   |
| [Triplanar](Triplanar-Node.md)                                   | A method of generating UVs and sampling a texture by projecting in world space.                                 |
| [Parallax Mapping](Parallax-Mapping-Node.md)                     | Creates a parallax effect that displaces a material's UVs.                                                      |
| [Polar Coordinates](Polar-Coordinates-Node.md)                   | Converts the value of input UV to polar coordinates.                                                            |
| [Rotate](Rotate-Node.md)                                         | Rotates the value of input UV around a reference point defined by input Center by the amount of input Rotation. |
| [Tiling and Offset](Tiling-And-Offset-Node.md)                   | Tiles and offsets the value of input UV by the inputs Tiling and Offset respectively.                           |
| [Twirl](Twirl-Node.md)                                           | Applies a twirl warping effect similar to a black hole to the value of input UV.                                |
| [Parallax Occlusion Mapping](Parallax-Occlusion-Mapping-Node.md) | Creates a parallax effect that displaces a material's UVs and depth.                                            |
