# Inside Shader Graph

Learn about all concepts and features that make Shader Graph.

| Topic | Description |
| :--- | :--- |
| [Shader Graph Asset](Shader-Graph-Asset.md) | Learn about the asset type that contains any shader graph you create. |
| [Graph Target](Graph-Target.md) | Determine the end point compatibility of a shader you generate with Shader Graph. |
| [Node](Node.md) | Create nodes in your shader graph and learn about node interconnection details with ports and edges. |
| [Sub Graph](Sub-graph.md) | Create sub graphs that you can reference from inside other graphs. |
| [Sub Graph Asset](Sub-graph-Asset.md) | Learn about the asset type that contains any sub graph you create. |
| [Sticky Notes](Sticky-Notes.md) | Use sticky notes to write comments within your shader graphs. |
| [Color Modes](Color-Modes.md) | Select color modes to improve your graph readability according to certain criteria like node category, relative performance cost, data precision mode, or custom colors. |
| [Precision Modes](Precision-Modes.md) | Set precision modes for graphs, subgraphs, and nodes to help you optimize your content for different platforms. |
| [Preview Mode Control](Preview-Mode-Control.md) | Manually select your preferred preview mode for nodes that have a preview. |
| [Custom Render Textures](Custom-Render-Texture.md) | Create shaders that are compatible with Custom Render Texture Update and Initialization materials. |
| [Material Variants](materialvariant-SG.md) | Create variations based on a single material. |
| [Property Types](Property-Types.md) | Use properties in your shader graph to expose them as material properties and make them editable in the material that uses the shader. |
| [Keywords](Keywords.md) | Use keywords to create different variants for your shader graph. |
| [Data Types](Data-Types.md) | Learn about all data types available in Shader Graph. |
| [Port Bindings](Port-Bindings.md) | Learn about port bindings which ensure that some ports always meet data type expectations. |
| [Shader Stage](Shader-Stage.md) | Learn about shader stages that apply to specific ports according to their context compatibility. |
| [Surface options](surface-options.md) | Modify a specific set of properties for certain render pipeline targets. |
| [Custom Interpolators](Custom-Interpolators.md) | Pass custom data from the vertex context to the fragment context. |
