---
title: nodes-sample-mip-bias-sample-mode-table.md
---

| **Name**                | **Type** | **Option**   | **Description**                                                                                                                                                                                                                                                                                                                                                                                                           |
|-------------------------|----------|--------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Use Global Mip Bias** | Toggle   | N/A          | Enable Use Global Mip Bias to use the render pipeline's Global Mip Bias. This bias adjusts the percentage of texture information taken from a specific mip when sampling. For more information on mip bias, refer to Mipmaps introduction in the Unity User Manual.                                                                                                                                                       |
| N/A                     | N/A      | **Enabled**  | Shader Graph uses the render pipeline's Global Mip Bias to adjust the texture information taken when sampling.                                                                                                                                                                                                                                                                                                            |
| N/A                     | N/A      | **Disabled** | Shader Graph doesn't use the render pipeline's Global Mip Bias to adjust texture information when sampling.                                                                                                                                                                                                                                                                                                               |
| **Mip Sampling Mode**   | Dropdown | N/A          | Choose the sampling mode to use to calculate the mip level of the texture.                                                                                                                                                                                                                                                                                                                                                |
| N/A                     | N/A      | **Standard** | The render pipeline calculates and automatically selects the mip for the texture.                                                                                                                                                                                                                                                                                                                                         |
| N/A                     | N/A      | **LOD**      | The render pipeline lets you set an explicit mip for the texture on the node. The texture will always use this mip, regardless of the DDX or DDY calculations between pixels. Set the Mip Sampling Mode to LOD to connect the node to a Block node in the Vertex Context. For more information on Block nodes and Contexts, refer to Master Stack.                                                                        |
| N/A                     | N/A      | **Gradient** | The render pipeline lets you set the DDX and DDY values to use for its mip calculation, instead of using the values calculated from the texture's UV coordinates. For more information on DDX and DDY values, refer to Mipmaps introduction in the User Manual.                                                                                                                                                           |
| N/A                     | N/A      | **Bias**     | The render pipeline lets you set a bias to adjust the calculated mip for a texture up or down. Negative values bias the mip to a higher resolution. Positive values bias the mip to a lower resolution. The render pipeline can add this value to the value of the Global Mip Bias, or use this value instead of its Global Mip Bias. For more information on mip bias, refer to Mipmaps introduction in the User Manual. |
