using System.Linq;
using UnityEngine;

namespace UnityEditor.ShaderGraph
{
    sealed partial class GraphData : ISerializationCallbackReceiver
    {
        public static class GraphConcretization
        {
            public static void ConcretizeNode(AbstractMaterialNode node)
            {
                node.Concretize();
            }

            public static void ConcretizeProperties(GraphData graph)
            {
                // get all property nodes whose property doesn't exist?
                var propertyNodes = graph.GetNodes<PropertyNode>().Where(n => !graph.m_Properties.Any(p => p.value == n.property || n.property != null && p.value.objectId == n.property.objectId)).ToArray();
                foreach (var pNode in propertyNodes)
                {
                    if (graph.replaceInProgress)
                    {
                        // If the graph is being replaced, the replacement graph should already contain a concrete node for this property node.
                        graph.RemoveNodeNoValidate(pNode);
                    }
                    else
                    {
                        graph.ReplacePropertyNodeWithConcreteNodeNoValidate(pNode);
                    }
                }
            }

            public static void ConcretizeGraph(GraphData graph)
            {
                graph.graphIsConcretizing = true;
                try
                {
                    ConcretizeProperties(graph);
                    GraphDataUtils.ApplyActionLeafFirst(graph, ConcretizeNode);
                }
                catch (System.Exception e)
                {
                    graph.graphIsConcretizing = false;
                    throw e;
                }
                graph.graphIsConcretizing = false;
            }
        }
    }
}
