using UnityEngine;

public class Spieler : MonoBehaviour
{
    bool spielerSteht = false;
    readonly float translateFaktor = 3;
    readonly float rotateFaktor = 100;

    public GameObject kammerPrefab;

    GameObject tor;
    int torStatus = 0;
    public Material schwarzMat;
    public Material grauMat;

    GameObject kiste;
    int kisteIndex;
    int kisteStatus = 0;
    public GameObject[] schluessel = new GameObject[7];
    public GameObject[] besitz = new GameObject[7];

    int sperreStatus = 0;
    int sperreIndex;
    public GameObject[] sperre = new GameObject[6];

    void Start()
    {
        GameObject[,] kammer = new GameObject[4, 4];

        for (int x = 0; x < 4; x++)
            for (int z = 0; z < 4; z++)
                kammer[x, z] = Instantiate(kammerPrefab,
                   new Vector3(x * 10 + 5, 0, z * 10 + 5), Quaternion.identity);

        KammerKonfig(kammer[0, 0], true, false, true, true);
        KammerKonfig(kammer[0, 1], true, false, false, false);
        KammerKonfig(kammer[0, 2], true, false, true, false);
        KammerKonfig(kammer[0, 3], true, true, true, false);

        KammerKonfig(kammer[1, 0], true, true, false, true);
        KammerKonfig(kammer[1, 1], false, false, false, true);
        KammerKonfig(kammer[1, 2], true, false, true, false);
        KammerKonfig(kammer[1, 3], true, true, false, false);

        KammerKonfig(kammer[2, 0], false, false, false, true);
        KammerKonfig(kammer[2, 1], false, false, false, false);
        KammerKonfig(kammer[2, 2], true, true, false, false);
        KammerKonfig(kammer[2, 3], false, true, true, true);

        KammerKonfig(kammer[3, 0], false, true, true, true);
        KammerKonfig(kammer[3, 1], false, true, true, true);
        KammerKonfig(kammer[3, 2], false, false, true, true);
        KammerKonfig(kammer[3, 3], true, true, true, false);
    }

    void KammerKonfig(GameObject kammer, bool wandLinks,
          bool wandHinten, bool wandRechts, bool wandVorne)
    {
        if (wandLinks)
            kammer.transform.Find("WandLinksOffen").gameObject.SetActive(false);
        else
            kammer.transform.Find("WandLinks").gameObject.SetActive(false);

        if (wandHinten)
            kammer.transform.Find("WandHintenTor").gameObject.SetActive(false);
        else
            kammer.transform.Find("WandHinten").gameObject.SetActive(false);

        if (wandRechts)
            kammer.transform.Find("WandRechtsTor").gameObject.SetActive(false);
        else
            kammer.transform.Find("WandRechts").gameObject.SetActive(false);

        if (wandVorne)
            kammer.transform.Find("WandVorneOffen").gameObject.SetActive(false);
        else
            kammer.transform.Find("WandVorne").gameObject.SetActive(false);
    }

    void Update()
    {
        if (torStatus == 2)
        {
            tor.transform.position = tor.transform.position +
               new Vector3(0, Time.deltaTime, 0);
            if (tor.transform.position.y >= 1.5f)
            {
                torStatus = 3;
                spielerSteht = false;
                GetComponent<MeshRenderer>().material = grauMat;
                Invoke(nameof(TorSchliesst), 1.5f);
            }
        }
        else if (torStatus == 4)
        {
            tor.transform.position = tor.transform.position -
               new Vector3(0, Time.deltaTime, 0);
            if (tor.transform.position.y <= 0.5f)
                torStatus = 0;
        }

        if (kisteStatus == 2)
        {
            kiste.transform.position = kiste.transform.position +
               new Vector3(0, Time.deltaTime, 0);
            if (kiste.transform.position.y >= 1.1f)
            {
                kisteStatus = 3;
                Invoke(nameof(KisteSchliesst), 1.5f);
                if (besitz[kisteIndex].activeInHierarchy)
                {
                    spielerSteht = false;
                    GetComponent<MeshRenderer>().material = grauMat;
                }
            }
        }
        else if (kisteStatus == 4)
        {
            kiste.transform.position = kiste.transform.position -
               new Vector3(0, Time.deltaTime, 0);
            if (kiste.transform.position.y <= 0.5f)
                kisteStatus = 0;
        }

        if (!spielerSteht)
        {
            transform.Translate(new Vector3(0, 0, translateFaktor
               * Time.deltaTime * Input.GetAxis("Vertical")));
            transform.Rotate(new Vector3(0, rotateFaktor
               * Time.deltaTime * Input.GetAxis("Horizontal"), 0));
        }
    }

    void OnTriggerEnter(Collider coll)
    {
        if (coll.gameObject.CompareTag("Tor"))
        {
            tor = coll.gameObject;
            torStatus = 1;
            spielerSteht = true;
            GetComponent<MeshRenderer>().material = schwarzMat;
        }
        else if (coll.gameObject.CompareTag("Kiste"))
        {
            kiste = coll.gameObject;
            kisteIndex = System.Convert.ToInt32(kiste.name.Substring(5, 1));
            kisteStatus = 1;
            spielerSteht = true;
            GetComponent<MeshRenderer>().material = schwarzMat;
        }
        else if (coll.gameObject.CompareTag("Sperre"))
        {
            sperreIndex = System.Convert.ToInt32
               (coll.gameObject.name.Substring(6, 1));
            sperreStatus = 1;
            spielerSteht = true;
            GetComponent<MeshRenderer>().material = schwarzMat;
        }
    }

    void TorSchliesst()
    {
        torStatus = 4;
    }

    public void OeffneTor()
    {
        if (torStatus == 1)
            torStatus = 2;
    }

    void KisteSchliesst()
    {
        kisteStatus = 4;
    }

    public void OeffneKiste()
    {
        if (kisteStatus == 1)
            kisteStatus = 2;
    }

    public void NimmSchluesselAuf()
    {
        if (kisteStatus == 3)
        {
            besitz[kisteIndex].SetActive(true);
            schluessel[kisteIndex].SetActive(false);
            spielerSteht = false;
            GetComponent<MeshRenderer>().material = grauMat;
        }
    }

    public void SchliesseSperreAuf()
    {
        if (sperreStatus == 1 && besitz[sperreIndex].activeInHierarchy)
            sperre[sperreIndex].SetActive(false);
        sperreStatus = 0;
        spielerSteht = false;
        GetComponent<MeshRenderer>().material = grauMat;
    }

    public void SpielstandSpeichern()
    {
        PlayerPrefs.SetFloat("spielerPosX", transform.position.x);
        PlayerPrefs.SetFloat("spielerPosZ", transform.position.z);
        PlayerPrefs.SetFloat("spielerRotY", transform.rotation.eulerAngles.y);

        string besitzString = "";
        for (int i = 0; i < 7; i++)
        {
            if (besitz[i].activeInHierarchy)
                besitzString += "1";
            else
                besitzString += "0";
        }
        PlayerPrefs.SetString("besitzString", besitzString);

        PlayerPrefs.Save();
    }

    public void SpielstandLaden()
    {
        if (PlayerPrefs.HasKey("spielerPosX") && PlayerPrefs.HasKey
           ("spielerPosZ") && PlayerPrefs.HasKey("spielerRotY"))
        {
            transform.position = new Vector3(PlayerPrefs.GetFloat
               ("spielerPosX"), 0.2f, PlayerPrefs.GetFloat("spielerPosZ"));
            Quaternion q = new Quaternion();
            q.eulerAngles = new Vector3(0, PlayerPrefs.GetFloat("spielerRotY"), 0);
            transform.rotation = q;
        }

        if (PlayerPrefs.HasKey("besitzString"))
        {
            string besitzString = PlayerPrefs.GetString("besitzString");
            for (int i = 0; i < 7; i++)
            {
                if (besitzString.Substring(i, 1) == "1")
                {
                    besitz[i].SetActive(true);
                    schluessel[i].SetActive(false);
                }
                else
                {
                    besitz[i].SetActive(false);
                    schluessel[i].SetActive(true);
                }
            }
        }
    }
}
