using UnityEngine;
using TMPro;

public class Training : MonoBehaviour
{
    public GameObject[] Zahl = new GameObject[10];
    public int zahlMax;

    public TextMeshProUGUI infoAnzeige;

    readonly int zahlMaxGrenze = 9;
    public bool buttonsKlickbar = false;

    void Start()
    {
        zahlMax = 2;
        for (int i = 0; i <= 9; i++)
            Zahl[i].SetActive(false);
        Invoke(nameof(ButtonsVerteilen), 3);
    }

    void ButtonsVerteilen()
    {
        for (int i = 0; i <= zahlMax; i++)
        {
            bool positionDoppelt;
            Vector3 positionNeu;

            do
            {
                positionNeu = new Vector3(Random.Range(1, 25) * 50,
                   Random.Range(1, 14) * 50 - 10, 0);
                positionDoppelt = false;

                for (int k = 0; k < i; k++)
                {
                    if ((Zahl[k].GetComponent<RectTransform>().position -
                       positionNeu).magnitude < 25)
                    {
                        positionDoppelt = true;
                        break;
                    }
                }
            }
            while (positionDoppelt);

            Zahl[i].GetComponent<RectTransform>().position = positionNeu;
        }

        for (int i = 0; i <= 9; i++)
        {
            if (i <= zahlMax)
            {
                Zahl[i].SetActive(true);
                Zahl[i].GetComponentInChildren<TextMeshProUGUI>().text = i + "";
            }
            else
                Zahl[i].SetActive(false);
        }

        Invoke(nameof(ZahlenLoeschen), zahlMax);
    }

    void ZahlenLoeschen()
    {
        for (int i = 0; i <= zahlMax; i++)
            Zahl[i].GetComponentInChildren<TextMeshProUGUI>().text = "";
        infoAnzeige.text = "Nacheinander anklicken";
        Invoke(nameof(InfoEntfernen), 1);
        buttonsKlickbar = true;
    }

    void InfoEntfernen()
    {
        infoAnzeige.GetComponent<RectTransform>().transform.Translate(0, 500, 0);
    }

    void Weiter()
    {
        infoAnzeige.text = "Positionen merken";
        ButtonsVerteilen();
    }

    public void Vorwaerts()
    {
        zahlMax++;
        buttonsKlickbar = false;
        infoAnzeige.GetComponent<RectTransform>().transform.Translate(0, -500, 0);

        if (zahlMax > zahlMaxGrenze)
            infoAnzeige.text = "Mehr geht zurzeit nicht";
        else
        {
            infoAnzeige.text = "Geschafft, vorwrts auf " + zahlMax;
            Invoke(nameof(Weiter), 2);
        }
    }

    public void Zurueck()
    {
        zahlMax--;
        buttonsKlickbar = false;
        infoAnzeige.GetComponent<RectTransform>().transform.Translate(0, -500, 0);
        infoAnzeige.text = "Fehler, zurck auf " + zahlMax;
        Invoke(nameof(Weiter), 2);
    }
}
