﻿using UnityEngine;

public class Fahrzeug : MonoBehaviour
{
	static readonly float[] bewegungFaktorFeld = new float[4] {-0.9f, -1.6f, 1.3f, 0.8f};
	static int anzahl = 0;
	float bewegungFaktor;
	public Frosch froschKlasse;

	void Start()
	{
		int index;
		if (transform.position.y > 1.9f)
			index = 0;
		else if (transform.position.y > 0.9f)
			index = 1;
		else if (transform.position.y < -0.9f)
			index = 3;
		else
			index = 2;

		anzahl++;
		if(anzahl % 10 == 0)
			bewegungFaktorFeld[index] *= Random.Range(0.95f, 1.1f);
		bewegungFaktor = bewegungFaktorFeld[index];
	}

	void Update()
	{
		if (!froschKlasse.spielGestartet)
			return;

		float xNeu = transform.position.x + 3 * Time.deltaTime * bewegungFaktor;
		transform.position = new Vector2(xNeu, transform.position.y);

		if (bewegungFaktor > 0 && xNeu > 10.0f)
			transform.position = new Vector2(-10.0f, transform.position.y);
		else if (bewegungFaktor < 0 && xNeu < -10.0f)
			transform.position = new Vector2(10.0f, transform.position.y);
	}
}
