﻿using UnityEngine;
using UnityEngine.UI;

public class Frosch : MonoBehaviour
{
	bool startUnten = true;
	float zeitStart;
	public bool spielGestartet = true;

	public AudioClip springenAudio;
	public AudioClip punktAudio;
	public AudioClip lebenWegAudio;
	public AudioClip verlorenAudio;
	public AudioClip endeAudio;

	int punkte = 0;
	public Text punkteAnzeige;

	int leben = 3;
	public Text lebenAnzeige;
	public Text infoAnzeige;

	void Start()
	{
		zeitStart = Time.time;
	}

	void Update()
	{
		float yAlt = transform.position.y;
		float yNeu = yAlt;

		if(Input.GetKeyDown(KeyCode.UpArrow))
		{
			yNeu++;
			if (yNeu > 3.1f)
				yNeu = 3;
		}
		else if(Input.GetKeyDown(KeyCode.DownArrow))
		{
			yNeu--;
			if (yNeu < -2.1f)
				yNeu = -2;
		}

		transform.position = new Vector2(transform.position.x, yNeu);

		if (yNeu != yAlt)
		{
			if (startUnten && yNeu > 2.1f || !startUnten && yNeu < -1.1f)
			{
				punkte++;
				punkteAnzeige.text = "Punkte: " + punkte;
				AudioSource.PlayClipAtPoint(punktAudio, transform.position);
				startUnten = !startUnten;
			}
			else
				AudioSource.PlayClipAtPoint(springenAudio, transform.position);
		}

		float restZeit = 30 - (Time.time - zeitStart);
		if (restZeit > 0.5f)
			infoAnzeige.text = string.Format ("Noch {0,1:0} sec.", restZeit);
		else
		{
			gameObject.SetActive (false);
			infoAnzeige.text = "Ende";
			spielGestartet = false;
			AudioSource.PlayClipAtPoint(endeAudio, transform.position);
		}
	}

	void OnTriggerEnter2D(Collider2D coll)
	{
		if (coll.gameObject.CompareTag("Fahrzeug"))
		{
			leben--;
			lebenAnzeige.text = "Leben: " + leben;
			gameObject.SetActive (false);

			if (leben > 0)
			{
				Invoke (nameof(NeuesLeben), 1);
				AudioSource.PlayClipAtPoint (lebenWegAudio, transform.position);
			}
			else
			{
				infoAnzeige.text = "Verloren";
				spielGestartet = false;
				AudioSource.PlayClipAtPoint (verlorenAudio, transform.position);
			}
		}
	}

	void NeuesLeben()
	{
		transform.position = new Vector2(0, -2);
		startUnten = true;
		gameObject.SetActive(true);
	}
}
