using UnityEngine;
using TMPro;

public class Spieler : MonoBehaviour
{
    readonly float eingabeFaktor = 10;
    public GameObject gewinn;

    int anzahlPunkte = 0;
    public TextMeshProUGUI punkteAnzeige;

    int anzahlLeben = 3;
    public TextMeshProUGUI lebenAnzeige;

    float zeitStart;
    bool spielGestartet = false;
    public TextMeshProUGUI zeitAnzeige;

    public TextMeshProUGUI zeitAltAnzeige;

    public TextMeshProUGUI infoAnzeige;

    void Start()
    {
        float zeitAlt = 0;
        if (PlayerPrefs.HasKey("zeitAlt"))
            zeitAlt = PlayerPrefs.GetFloat("zeitAlt");
        zeitAltAnzeige.text = string.Format("Alt: {0,6:0.0} sec.", zeitAlt);
    }
    
    void Update()
    {
        /* Eingabe speichern */
        float xEingabe = Input.GetAxis("Horizontal");
        float yEingabe = Input.GetAxis("Vertical");
        if (yEingabe < 0)
        {
            return;
        }

        // Neue Position bestimmen
        float xNeu = transform.position.x +
           xEingabe * eingabeFaktor * Time.deltaTime;
        if (xNeu > 8.3f)
        {
            xNeu = 8.3f;
        }
        if (xNeu < -8.3f)
        {
            xNeu = -8.3f;
        }
        float yNeu = transform.position.y +
           yEingabe * eingabeFaktor * Time.deltaTime;
        transform.position = new Vector2(xNeu, yNeu);

        if (!spielGestartet && (xEingabe != 0 || yEingabe != 0))
        {
            spielGestartet = true;
            zeitStart = Time.time;
            infoAnzeige.text = "";
        }

        if (spielGestartet)
            zeitAnzeige.text = string.Format("Zeit: {0,6:0.0} sec.",
               Time.time - zeitStart);
    }

    void OnCollisionEnter2D(Collision2D coll)
    {
        if (coll.gameObject.CompareTag("Gewinn"))
        {
            anzahlPunkte++;
            if (anzahlPunkte < 6)
            {
                punkteAnzeige.text = "Punkte: " + anzahlPunkte;
                if (anzahlPunkte == 1)
                    infoAnzeige.text = "Du hast bereits 1 Punkt!";
                else
                    infoAnzeige.text = "Du hast bereits " + anzahlPunkte +
                        " Punkte!";
                Invoke(nameof(NaechsterGewinn), 2);
            }
            else
            {
                infoAnzeige.text = "Du hast gewonnen!";
                spielGestartet = false;
                gameObject.SetActive(false);
                gewinn.SetActive(false);
                PlayerPrefs.SetFloat("zeitAlt", Time.time - zeitStart);
                PlayerPrefs.Save();
            }
            float xNeu = Random.Range(-8.0f, 8.0f);

            float yNeu;
            if (anzahlPunkte < 2) yNeu = -2.7f;
            else if (anzahlPunkte < 4) yNeu = 0.15f;
            else yNeu = 3;

            gewinn.transform.position = new Vector2(xNeu, yNeu);
        }
        else if (coll.gameObject.CompareTag("Gefahr"))
        {
            anzahlLeben--;
            lebenAnzeige.text = "Leben: " + anzahlLeben;

            gameObject.SetActive(false);
            if (anzahlLeben > 0)
            { 
                infoAnzeige.text = "Du hast nur noch " + anzahlLeben + " Leben!";
                Invoke(nameof(NaechstesLeben), 2);
            }
            else
            {
                infoAnzeige.text = "Du hast verloren!";
                spielGestartet = false;
                gewinn.SetActive(false);
            }
        }
    }

    void NaechsterGewinn()
    {
        float xNeu = Random.Range(-8.0f, 8.0f);

        float yNeu;
        if (anzahlPunkte < 2) yNeu = -2.7f;
        else if (anzahlPunkte < 4) yNeu = 0.15f;
        else yNeu = 3;

        gewinn.transform.position = new Vector2(xNeu, yNeu);
        gewinn.SetActive(true);
        infoAnzeige.text = "";
    }

    void NaechstesLeben()
    {
        transform.position = new Vector2(0, -4.4f);
        gameObject.SetActive(true);
        infoAnzeige.text = "";
    }

    public void SpielNeuButton_Click()
    {
        if (spielGestartet)
            return;

        anzahlPunkte = 0;
        anzahlLeben = 3;
        float zeitAlt = 0;
        if (PlayerPrefs.HasKey("zeitAlt"))
            zeitAlt = PlayerPrefs.GetFloat("zeitAlt");

        punkteAnzeige.text = "Punkte: 0";
        lebenAnzeige.text = "Leben: 3";
        zeitAnzeige.text = "Zeit:    0.0 sec.";
        zeitAltAnzeige.text =
           string.Format("Alt: {0,6:0.0} sec.", zeitAlt);
        infoAnzeige.text =
           "Bei Bettigen einer beliebigen Taste beginnt das Spiel.\n"
           + "Lenke den Affen mit den Pfeiltasten.\n"
           + "Sammle die Bananen, und vermeide die Tiger.";

        transform.position = new Vector2(0, -4.4f);
        gameObject.SetActive(true);

        gewinn.transform.position = new Vector2(4, -2.7f);
        gewinn.SetActive(true);
    }

    public void AnwendungEndeButton_Click()
    {
        if (!spielGestartet)
            Application.Quit();
    }
}
