using UnityEngine;
using TMPro;

public class Ball : MonoBehaviour
{
    public GameObject hEins, hZwei, hDrei, bueschelPrefab;

    Rigidbody2D rb;
    bool aufschlagRechts = true;

    public GameObject spielerLinks;
    public GameObject spielerRechts;
    readonly float eingabeFaktor = 10;

    int punkteLinks = 0;
    int punkteRechts = 0;
    public TextMeshProUGUI punkteLinksAnzeige;
    public TextMeshProUGUI punkteRechtsAnzeige;

    public AudioClip aufschlagAudio;
    public AudioClip abprallenAudio;
    public AudioClip punktAudio;
    public AudioClip verschiebenAudio;


    void Start()
    {
        rb = GetComponent<Rigidbody2D>(); 
        
        for (int i = 0; i < 100; i++)
            Instantiate(bueschelPrefab, new Vector2(Random.Range(-8.0f, 8.0f),
               Random.Range(-4.5f, 4.5f)), Quaternion.identity);
        HindernisseSetzen();
    }

    void HindernisseSetzen()
    {
        hEins.transform.position = new Vector2
         (Random.Range(-3.0f, 3.0f), Random.Range(-3.5f, 3.5f));

        do
        {
            hZwei.transform.position = new Vector2
             (Random.Range(-3.0f, 3.0f), Random.Range(-3.5f, 3.5f));
        }
        while ((hZwei.transform.position - hEins.transform.position).magnitude < 2);

        do
        {
            hDrei.transform.position = new Vector2
             (Random.Range(-3.0f, 3.0f), Random.Range(-3.5f, 3.5f));
        }
        while ((hDrei.transform.position - hEins.transform.position).magnitude < 2
           || (hDrei.transform.position - hZwei.transform.position).magnitude < 2);
    }

    void Update()
    {
        if (rb.linearVelocity.x > 0)
        {
            if (Input.GetKey(KeyCode.UpArrow))
            {
                float yNeu = spielerRechts.transform.position.y +
                   eingabeFaktor * Time.deltaTime;
                if (yNeu > 3.5f) yNeu = 3.5f;
                spielerRechts.transform.position = new Vector2(8.44f, yNeu);
            }
            else if (Input.GetKey(KeyCode.DownArrow))
            {
                float yNeu = spielerRechts.transform.position.y -
                   eingabeFaktor * Time.deltaTime;
                if (yNeu < -3.5f) yNeu = -3.5f;
                spielerRechts.transform.position = new Vector2(8.44f, yNeu);
            }
            else if (Input.GetKeyDown(KeyCode.LeftArrow))
            {
                spielerRechts.transform.Translate(-0.3f, 0, 0);
                AudioSource.PlayClipAtPoint(verschiebenAudio, transform.position);
                Invoke(nameof(SpielerRechtsZurueck), 0.2f);
            }

        }
        else if (rb.linearVelocity.x < 0)
        {
            float yNeu = spielerLinks.transform.position.y +
               eingabeFaktor * Time.deltaTime;
            if (yNeu > 3.5f) yNeu = 3.5f;
            Vector3 oben = new(-8.44f, yNeu, 0);

            yNeu = spielerLinks.transform.position.y -
               eingabeFaktor * Time.deltaTime;
            if (yNeu < -3.5f) yNeu = -3.5f;
            Vector3 unten = new(-8.44f, yNeu, 0);

            if ((oben - transform.position).magnitude <
                  (unten - transform.position).magnitude)
                spielerLinks.transform.position = oben;
            else
                spielerLinks.transform.position = unten;
        }
        else if (rb.linearVelocity.x == 0)
        {
            if (aufschlagRechts && Input.GetKeyDown(KeyCode.LeftArrow))
            {
                rb.AddForce(new Vector2(-200, 300));
                AudioSource.PlayClipAtPoint(aufschlagAudio, transform.position);
            }
            else if (!aufschlagRechts && Input.GetKeyDown(KeyCode.D))
            {
                rb.AddForce(new Vector2(200, 300));
                AudioSource.PlayClipAtPoint(aufschlagAudio, transform.position);
            }
        }
    }

    void SpielerRechtsZurueck()
    {
        spielerRechts.transform.Translate(0.3f, 0, 0);
        AudioSource.PlayClipAtPoint(verschiebenAudio, transform.position);
    }

    void SpielerLinksZurueck()
    {
        spielerLinks.transform.Translate(-0.3f, 0, 0);
        AudioSource.PlayClipAtPoint(verschiebenAudio, transform.position);
    }

    void OnCollisionEnter2D(Collision2D coll)
    {
        if (coll.gameObject.CompareTag("WandLinks"))
        {
            punkteRechts++;
            punkteRechtsAnzeige.text = punkteRechts + "";
            AudioSource.PlayClipAtPoint(punktAudio, transform.position);
            aufschlagRechts = true;
            gameObject.SetActive(false);
            Invoke(nameof(BallAufStartRechts), 1);
        }
        else if (coll.gameObject.CompareTag("WandRechts"))
        {
            punkteLinks++;
            punkteLinksAnzeige.text = punkteLinks + "";
            AudioSource.PlayClipAtPoint(punktAudio, transform.position);
            aufschlagRechts = false;
            gameObject.SetActive(false);
            Invoke(nameof(BallAufStartLinks), 1);
        }
        else if (coll.gameObject.CompareTag("Spieler"))
            rb.linearVelocity = new Vector2(rb.linearVelocity.x * 1.02f,
                rb.linearVelocity.y * 1.02f);
        else
            AudioSource.PlayClipAtPoint(abprallenAudio, transform.position);
    }

    void BallAufStartRechts()
    {
        transform.position = new Vector2(7.99f, 0);
        BallAufStart();
    }

    void BallAufStartLinks()
    {
        transform.position = new Vector2(-7.99f, 0);
        BallAufStart();
    }

    void BallAufStart()
    {
        HindernisseSetzen();
        spielerLinks.transform.position = new Vector2(-8.44f, 0);
        spielerRechts.transform.position = new Vector2(8.44f, 0);
        gameObject.SetActive(true);
    }

}
