﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections.Generic;

// Verhalten der roten Gefahren
public class Gefahr : MonoBehaviour
{
	public int x, y;

	public Labyrinth labyrinthKlasse;
	public Spieler spielerKlasse;

	public Text infoAnzeige;
	public AudioClip verlorenAudio;

	void Start ()
	{
		Invoke(nameof(Setzen), 0.1f);		
	}

	void Setzen()
	{
		// Startwerte
		if (name == "GefahrEins")
		{
			x = 3;
			y = labyrinthKlasse.hoehe - 4;
		}
		else if (name == "GefahrZwei")
		{
			x = labyrinthKlasse.breite / 2;
			y = labyrinthKlasse.hoehe - 4;
		}
		else if (name == "GefahrDrei")
		{
			x = labyrinthKlasse.breite / 2;
			y = 3;
		}
		else if (name == "GefahrVier")
		{
			x = labyrinthKlasse.breite - 4;
			y = 3;
		}

		labyrinthKlasse.wert [x, y] = 4;
		transform.position = labyrinthKlasse.Vector3Position (x, y);

		// Selbständige Bewegung starten
		Bewegen ();
	}

	void Bewegen ()
	{
		if (spielerKlasse.ende)
			return;

        // Erste Liste mit vier möglichen Positionen
        List<Position> positionListe = new List<Position>
        {
            new Position(x + 1, y, labyrinthKlasse, spielerKlasse),
            new Position(x - 1, y, labyrinthKlasse, spielerKlasse),
            new Position(x, y + 1, labyrinthKlasse, spielerKlasse),
            new Position(x, y - 1, labyrinthKlasse, spielerKlasse)
        };

        // Falls Spieler erreicht: Ende
        for (int i = 0; i < positionListe.Count; i++)
			if (labyrinthKlasse.wert [positionListe [i].GetX (), positionListe [i].GetY ()] == 2)
			{
				infoAnzeige.text = "Verloren";
				AudioSource.PlayClipAtPoint(verlorenAudio, transform.position);
				spielerKlasse.ende = true;
				return;
			}

		// Falls Position nicht frei: Position aus Liste löschen
		for (int i = positionListe.Count - 1; i >= 0; i--)
			if (labyrinthKlasse.wert [positionListe [i].GetX (), positionListe [i].GetY ()] != 0)
				positionListe.RemoveAt (i);

		// Keine Auswahl möglich?
		if (positionListe.Count == 0)
			return;

		// Zweite Liste mit Positionen, inkl. Wahrscheinlichkeiten
		List<Position> probListe = new List<Position>();

		do
		{
			// Position des Elements mit dem kleinsten Abstand finden
			int minPos = 0;
			for (int i = 0; i < positionListe.Count; i++)
				if(positionListe[i].GetSpielerAbstand() < positionListe[minPos].GetSpielerAbstand())
					minPos = i;

			// Übernahme, mit Wahrscheinlichkeit
			for(int i = 1; i<= positionListe.Count; i++)
				probListe.Add(positionListe[minPos]);

			// Löschen des Elements
			positionListe.RemoveAt(minPos);
		}
		while(positionListe.Count > 0);

		// Zufällige Auswahl treffen, Feld ändern, Position speichern, bewegen
		int zufall = Random.Range(0, probListe.Count);
		labyrinthKlasse.wert [x, y] = 0;
		x = probListe [zufall].GetX ();
		y = probListe [zufall].GetY ();
		labyrinthKlasse.wert [x, y] = 4;
		transform.position = labyrinthKlasse.Vector3Position (probListe [zufall].GetX (), probListe [zufall].GetY ());

		// Und weiter ...
		Invoke (nameof(Bewegen), 0.3f);
	}
}
