﻿using UnityEngine;
using UnityEngine.UI;
using System.Collections.Generic;

// Verhalten des grünen Gewinns
public class Gewinn : MonoBehaviour
{
	public int x, y;

	public Labyrinth labyrinthKlasse;
	public Spieler spielerKlasse;

	public Text infoAnzeige;
	public AudioClip gewonnenAudio;

	void Start ()
	{
		Invoke(nameof(Setzen), 0.1f);		
	}

	void Setzen()
	{
		// Startwerte
		x = labyrinthKlasse.breite - 4;
		y = labyrinthKlasse.hoehe - 4;
		labyrinthKlasse.wert [x, y] = 3;
		transform.position = labyrinthKlasse.Vector3Position (x, y);

		// Selbständige Bewegung starten
		Bewegen ();
	}

	void Bewegen ()
	{
		if (spielerKlasse.ende)
			return;

        // Erste Liste mit vier möglichen Positionen
        List<Position> positionListe = new List<Position>
        {
            new Position(x + 1, y, labyrinthKlasse, spielerKlasse),
            new Position(x - 1, y, labyrinthKlasse, spielerKlasse),
            new Position(x, y + 1, labyrinthKlasse, spielerKlasse),
            new Position(x, y - 1, labyrinthKlasse, spielerKlasse)
        };

        // Falls Spieler erreicht: Ende
        for (int i = 0; i < positionListe.Count; i++)
			if (labyrinthKlasse.wert [positionListe [i].GetX (), positionListe [i].GetY ()] == 2)
			{
				infoAnzeige.text = "Gewonnen";
				AudioSource.PlayClipAtPoint(gewonnenAudio, transform.position);
				spielerKlasse.ende = true;
				return;
			}

		// Falls Position nicht frei: Position aus Liste löschen
		for (int i = positionListe.Count - 1; i >= 0; i--)
			if (labyrinthKlasse.wert [positionListe [i].GetX (), positionListe [i].GetY ()] != 0)
				positionListe.RemoveAt (i);

		// Keine Auswahl möglich?
		if (positionListe.Count == 0)
			return;

		// Zufällige Auswahl treffen, Feld ändern, Position speichern, bewegen
		int zufall = Random.Range(0, positionListe.Count);
		labyrinthKlasse.wert [x, y] = 0;
		x = positionListe [zufall].GetX ();
		y = positionListe [zufall].GetY ();
		labyrinthKlasse.wert [x, y] = 4;
		transform.position = labyrinthKlasse.Vector3Position (positionListe [zufall].GetX (), positionListe [zufall].GetY ());

		// Und weiter ...
		Invoke (nameof(Bewegen), 0.3f);
	}
}
