﻿using UnityEngine;

// Verwaltung des zweidimensionalen Felds
// Anzeige und Änderung des Labyrinths
public class Labyrinth : MonoBehaviour
{
	// Größe, Wertfeld: 0=Nichts, 1=Wand, 2=Spieler, 3=Ziel, 4=Gefahr
	public int breite, hoehe;
	public int[,] wert;

	// Prefab für sichtbares Element
	public GameObject wandPrefab;

	void Start ()
	{
		// Startwerte
		breite = 59;
		hoehe = 33;
		wert = new int[breite, hoehe];

		// Wand-Elemente als Rahmen setzen, Mitte leeren
		for (int x = 0; x < breite; x++)
			for (int y = 0; y < hoehe; y++)
				if(x==0 || x == breite-1 || y==0 | y == hoehe-1)
					wert [x, y] = 1;
				else
					wert [x, y] = 0;

		// Zufällige Wand-Elemente im Feld setzen
		for (int i = 0; i < 400; i++)
		{
			int x, y;
			do
			{
				x = Random.Range (1, breite - 1);
				y = Random.Range (1, hoehe - 1);
			}
			while(wert [x, y] != 0);
			wert [x, y] = 1;
		}

		// Wand-Elemente sichtbar machen
		for (int x = 0; x < breite; x++)
			for (int y = 0; y < hoehe; y++)
				if(wert[x, y] == 1)
					Instantiate (wandPrefab, Vector3Position(x, y), Quaternion.identity);
	}

	// Liefert Position zu X/Y-Rasterwert
	public Vector3 Vector3Position(int x, int y)
	{
		return new Vector3 (x * 0.3f - 8.7f, y * 0.3f - 4.8f, 0);
	}
}
