﻿using UnityEngine;

// Mögliche neue Position für rote Gefahr oder grünen Gewinn
public class Position
{
    private readonly int x;
    private readonly int y;
    readonly float spielerAbstand;

	// Konstruktor, mit Berechnung aller Eigenschaften
	public Position(int xNeu, int yNeu, Labyrinth labyrinthKlasse, Spieler spielerKlasse)
	{
		x = xNeu;
		y = yNeu;
		Vector3 pos = labyrinthKlasse.Vector3Position (x, y);
		spielerAbstand = (spielerKlasse.transform.position - pos).magnitude;
	}

	public int GetX()
	{
		return x;
	}

	public int GetY()
	{
		return y;
	}

	public float GetSpielerAbstand()
	{
		return spielerAbstand;
	}
}
