﻿using UnityEngine;
using UnityEngine.UI;

// Verhalten des schwarzen Spielers
public class Spieler : MonoBehaviour
{
	public int x, y;
	int deltaX, deltaY;

	public Labyrinth labyrinthKlasse;
	public bool ende;
	public Text infoAnzeige;

	public AudioClip sprungAudio;
	public AudioClip gewonnenAudio;

	void Start ()
	{
		Invoke(nameof(Setzen), 0.1f);		
	}

	void Setzen()
	{
		// Startwerte
		x = 3;
		y = 3;
		labyrinthKlasse.wert [x, y] = 2;
		transform.position = labyrinthKlasse.Vector3Position (x, y);
		ende = false;

		deltaX = 1;
		deltaY = 0;

		// Selbständige (gesteuerte) Bewegung starten
		Bewegen();
	}

	void Update()
	{
		if (ende)
			return;

		// Richtung der Bewegung ändern
		if (Input.GetKeyDown (KeyCode.RightArrow))
		{
			deltaX = 1;
			deltaY = 0;
		}
		else if (Input.GetKeyDown (KeyCode.DownArrow))
		{
			deltaX = 0;
			deltaY = -1;
		}
		else if (Input.GetKeyDown (KeyCode.LeftArrow))
		{
			deltaX = -1;
			deltaY = 0;
		}
		else if (Input.GetKeyDown (KeyCode.UpArrow))
		{
			deltaX = 0;
			deltaY = 1;
		}
	}

	void Bewegen()
	{
		if (ende)
			return;

		// Neue Position ermitteln
		int xNeu = x + deltaX;
		int yNeu = y + deltaY;

		// Falls an neuer Position das Ziel erreicht: Ende
		if (labyrinthKlasse.wert [xNeu, yNeu] == 3)
		{
			infoAnzeige.text = "Gewonnen";
			AudioSource.PlayClipAtPoint(gewonnenAudio, transform.position);
			ende = true;
			return;
		}

		// Falls neue Position frei: bewegen
		else if (labyrinthKlasse.wert [xNeu, yNeu] == 0)
		{			
			// Alte Position räumen, neue Position belegen
			labyrinthKlasse.wert [x, y] = 0;
			x = xNeu;
			y = yNeu;
			labyrinthKlasse.wert [x, y] = 2;
			AudioSource.PlayClipAtPoint(sprungAudio, transform.position);
			transform.position = labyrinthKlasse.Vector3Position (x, y);
		}

		// Und weiter ...
		Invoke (nameof(Bewegen), 0.5f);
	}
}
