using TMPro;
using UnityEngine;


public class Fahrer : MonoBehaviour
{
    bool rundenZaehlenErlaubt = true;
    bool inBereich = false;
    int runde = 0;

    readonly float[] rundenzeitStart = new float[3];
    public TextMeshProUGUI[] rundenzeitAnzeige = new TextMeshProUGUI[3];

    public Countdown countdownKlasse;

    void Update()
    {
        if (rundenZaehlenErlaubt)
        {
            if (transform.position.x > 20 && transform.position.x < 30)
            {
                if (transform.position.z > 12 && transform.position.z < 12.5f)
                {
                    inBereich = true;
                }
                else if (inBereich && transform.position.z > 12.5f &&
                   transform.position.z < 13)
                {
                    runde++;
                    if (runde == 1)
                        rundenzeitStart[0] = countdownKlasse.zeitStartGesamt;
                    else if (runde < 4)
                        rundenzeitStart[runde - 1] = Time.time;
                    inBereich = false;
                    rundenZaehlenErlaubt = false;
                    Invoke(nameof(RundenZaehlenErlauben), 10);
                }
            }
        }

        if (runde == 0)
        {
            if (countdownKlasse.zeitStartGesamt > 0)
                rundenzeitAnzeige[0].text =
                   string.Format("Runde{0,2:0}: {1,6:0.0} sec.", 0,
                   Time.time - countdownKlasse.zeitStartGesamt);
        }
        else if (runde < 4)
            rundenzeitAnzeige[runde - 1].text =
               string.Format("Runde{0,2:0}: {1,6:0.0} sec.", runde,
               Time.time - rundenzeitStart[runde - 1]);
    }

    void RundenZaehlenErlauben()
    {
        rundenZaehlenErlaubt = true;
    }
}
