using UnityEngine;

public class Fahrzeug : MonoBehaviour
{
    readonly float drehmomentFaktor = 25000;
    public WheelCollider collVL, collVR, collHL, collHR;

    readonly float lenkwinkelFaktor = 30;
    public GameObject radVL, radVR;

    public Countdown countdownKlasse;

    void Update()
    {
        if (countdownKlasse.zeitStartGesamt <= 0)
            return;

        float drehmoment;
        if (name == "FahrzeugEins")
            drehmoment = drehmomentFaktor * Time.deltaTime *
               Input.GetAxis("Fire1");
        else
            drehmoment = drehmomentFaktor * Time.deltaTime *
               Input.GetAxis("Vertical");
        collVL.motorTorque = drehmoment;
        collVR.motorTorque = drehmoment;
        collHL.motorTorque = drehmoment;
        collHR.motorTorque = drehmoment;

        float lenkwinkel;
        if (name == "FahrzeugEins")
            lenkwinkel = lenkwinkelFaktor * Input.GetAxis("Fire2");
        else
            lenkwinkel = lenkwinkelFaktor * Input.GetAxis("Horizontal");
        collVL.steerAngle = lenkwinkel;
        collVR.steerAngle = lenkwinkel;

        radVL.transform.localEulerAngles = new Vector3(
           radVL.transform.localEulerAngles.x, collVL.steerAngle,
           radVL.transform.localEulerAngles.z);
        radVR.transform.localEulerAngles = new Vector3(
           radVR.transform.localEulerAngles.x, collVR.steerAngle,
           radVR.transform.localEulerAngles.z);
    }
}
