using UnityEngine;
using System.Collections.Generic;
using TMPro;

public class Kopf : MonoBehaviour
{
    Rigidbody rb;
    List<GameObject> segmentListe;

    int anzahlPunkte = 0;
    public TextMeshProUGUI punkteAnzeige;

    float zeitStart;
    bool spielGestartet;
    public TextMeshProUGUI zeitAnzeige;

    void Start()
    {
        rb = GetComponent<Rigidbody>();
        segmentListe = new List<GameObject> { GameObject.Find("Kopf") };
        for (int i = 1; i <= 10; i++)
            segmentListe.Add(GameObject.Find("Segment" + i));
        spielGestartet = true;
        zeitStart = Time.time;
    }

    void Update()
    {
        if (Input.GetKey(KeyCode.UpArrow))
            rb.AddForce(0, 0, 40);
        else if (Input.GetKey(KeyCode.DownArrow))
            rb.AddForce(0, 0, -40);
        else if (Input.GetKey(KeyCode.RightArrow))
            rb.AddForce(40, 0, 0);
        else if (Input.GetKey(KeyCode.LeftArrow))
            rb.AddForce(-40, 0, 0);

        if (spielGestartet)
            zeitAnzeige.text = string.Format("Zeit: {0,6:0.0} sec.",
               Time.time - zeitStart);
    }

    void OnTriggerEnter(Collider coll)
    {
        if (coll.gameObject.CompareTag("Beute"))
        {
            Vector3 positionAlt = coll.gameObject.transform.position;
            Vector3 positionNeu;

            anzahlPunkte++;
            punkteAnzeige.text = "Punkte: " + anzahlPunkte;

            do
            {
                positionNeu = new Vector3(Random.Range(-4.0f, 4.0f),
                                     0.2f, Random.Range(-4.0f, 4.0f));
            }
            while ((positionNeu - positionAlt).magnitude < 3);
            coll.gameObject.transform.position = positionNeu;

            if (segmentListe.Count > 2)
            {
                Destroy(segmentListe[^2].GetComponent<HingeJoint>());
                Destroy(segmentListe[^1]);
                segmentListe.RemoveAt(segmentListe.Count - 1);
            }

            if (anzahlPunkte >= 10)
            {
                spielGestartet = false;
                Destroy(GameObject.Find("Segment1"));
                Destroy(GameObject.Find("Kopf"));
            }
        }
    }

    void OnCollisionEnter(Collision coll)
    {
        if (coll.gameObject.CompareTag("Rand"))
            RandGetroffen();
    }

    public void RandGetroffen()
    {
        anzahlPunkte--;
        punkteAnzeige.text = "Punkte: " + anzahlPunkte;
    }
}
