using TMPro;
using UnityEngine;

public class Spieler : MonoBehaviour
{
    readonly float eingabeFaktor = 10;
    public GameObject[] geschoss = new GameObject[3];

    public GefahrGewinn gefahrGewinnKlasse;
    int energie = 10;
    public GameObject balkenWert;

    public GameObject[] gefahr = new GameObject[3];
    public GameObject gewinn;
    float zeitStart;
    bool spielGestartet = true;
    public TextMeshProUGUI zeitAnzeige;
    public TextMeshProUGUI infoAnzeige;

    public AudioClip kollisionGruenAudio;
    public AudioClip kollisionRotAudio;
    public AudioClip geschossAudio;
    public AudioClip gewonnenAudio;
    public AudioClip verlorenAudio;

    void Start()
    {
        zeitStart = Time.time;
    }
    
    void Update()
    {
        float yEingabe = Input.GetAxis("Vertical");
        float yNeu = transform.position.y +
           yEingabe * eingabeFaktor * Time.deltaTime;
        if (yNeu > 4.75f) yNeu = 4.75f;
        else if (yNeu < -4.75f) yNeu = -4.75f;
        transform.position = new Vector2(transform.position.x, yNeu);

        if (Input.GetButtonDown("Fire1"))
            for (int i = 0; i < 3; i++)
                if (!geschoss[i].activeSelf)
                {
                    geschoss[i].transform.position = new Vector2
                       (transform.position.x + 1.7f, transform.position.y);
                    geschoss[i].SetActive(true);
                    AudioSource.PlayClipAtPoint(geschossAudio, transform.position);
                    break;
                }

        if (spielGestartet)
            zeitAnzeige.text = string.Format("Zeit: {0,6:0.0} sec.",
               Time.time - zeitStart);
    }

    void OnTriggerEnter2D(Collider2D coll)
    {
        coll.gameObject.transform.position = new Vector2
           (Random.Range(9.5f, 19.0f), Random.Range(-4.75f, 4.75f));
        gefahrGewinnKlasse.xAenderungBasis *= 1.01f;
        if (coll.gameObject.CompareTag("Gefahr"))
        {
            AudioSource.PlayClipAtPoint(kollisionRotAudio, transform.position);
            EnergieAnzeige(-1);
        }
        else if (coll.gameObject.CompareTag("Gewinn"))
        {
            AudioSource.PlayClipAtPoint(kollisionGruenAudio, transform.position);
            EnergieAnzeige(1);
        }
    }

    public void EnergieAnzeige(int wert)
    {
        energie += wert;
        balkenWert.transform.localScale = new Vector3(0.8f, energie / 2.0f, 0);
        if (energie > 40)
            EndeSpiel("gewonnen", gewonnenAudio);
        if (energie < 1)
            EndeSpiel("verloren", verlorenAudio);
    }

    void EndeSpiel(string tx, AudioClip endeAudio)
    {
        spielGestartet = false;
        infoAnzeige.text = "Sie haben " + tx;
        AudioSource.PlayClipAtPoint(endeAudio, transform.position);

        for (int i = 0; i < 3; i++)
        {
            geschoss[i].SetActive(false);
            gefahr[i].SetActive(false);
        }
        gewinn.SetActive(false);
    }
}
