---
title: "Inhalt"
date: 2021-09-07T12:46:34+02:00
draft: false
---

Das kompakte Buch richtet sich an Software-Entwickler. Es ist in drei Teile gegliedert:

* Teil I gibt eine Einführung in Docker und stellt seine Werkzeuge und Syntax vor. Hier finden Sie unter anderem eine Referenz aller wichtigen docker-Kommandos sowie eine Beschreibung der Syntax für Dockerfile und docker-compose.yml.

* Teil II stellt den Werkzeugkasten vor, aus dessen Komponenten Sie Docker-Applikationen zusammensetzen können. Dazu zählen unter anderem das schlanke Alpine Linux, die Webserver Apache und Nginx, Node.js und HAProxy, die Programmiersprachen JavaScript, Java, PHP, Ruby, Python und Swift, die Datenbanksysteme MariaDB/MySQL, MongoDB, Redis und PostgreSQL sowie komplette Webapplikationen wie WordPress, Joomla oder Nextcloud.

* Um Docker in der Praxis geht es schließlich in Teil III: Konkrete Projekte illustrieren, wie Docker in der Praxis effizient und zielführend eingesetzt wird:
  *   Realisierung einer modernen, skalierbaren Webapplikation mit Docker (Vue.js + Node.js + MongoDB + Redis)
  *   Visualisierung und Monitoring mit Grafana
  *   Umbau vorhandener Software-Projekte in Docker-Projekte
  *   Verwendung von gitlab
  *   Continuous Integration (CI) und Continuous Deployment (CD)
  *   Sicherheit
  *   Cloud (Docker Swarm und Kubernetes im Zusammenspiel mit AWS, Azure und anderen Cloud-Angeboten)

**Neu in der 3. Auflage**: Für diese Auflage haben wir das Buch vollständig aktualisiert und die Einführungskapitel übersichtlicher strukturiert. Wichtige inhaltliche Neuerungen sind:

* Rootless Docker: Docker ohne root-Rechte verwenden
* CPU-Architekturen: Docker auf Apple-Computern mit ARM-Prozessoren
* Pull-Limit: Docker-Hub-Limits beim Image-Zugriff umgehen
* Container automatisch starten: restart-Option und systemd
* neue GUI-Tools: Docker Desktop, VSCode, Portainer
* Traefik: ein Proxy-Server speziell für Container-Anwendungen

Schauen Sie sich auch die [Leseprobe](https://s3-eu-west-1.amazonaws.com/gxmedia.galileo-press.de/leseproben/5393/leseprobe_rheinwerk_docker.pdf) (PDF) an.

