<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:include href="textausrichtung.xslt"/>
  <xsl:output method="text" version="1.0" encoding="ISO-8859-1"/>
  <!-- Ausgabe der obersten Kommentare -->
  <xsl:template match="//comment()[local-name(parent::*)='schema']">
    <xsl:value-of select="."/>
    <xsl:text>&#xD;</xsl:text>
    <xsl:call-template name="Einzug">
      <xsl:with-param name="wert" select="'-'"/>
      <xsl:with-param name="grenze" select="30"/>
    </xsl:call-template>
    <xsl:text>&#xD;</xsl:text>
  </xsl:template>
  <!-- Ausgabe der obersten Elemente -->
  <xsl:template match="//*[local-name(parent::*)='schema']">
    <xsl:call-template name="Einzug">
      <xsl:with-param name="grenze" select="5"/>
    </xsl:call-template>
    <!-- Ausgabe des Elements -->
    <xsl:value-of select="local-name(.)"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@name"/>
    <xsl:text>&#xD;</xsl:text>
    <!-- Ausgabe der Attribute -->
    <xsl:for-each select="@*">
      <xsl:call-template name="Einzug">
        <xsl:with-param name="grenze" select="10"/>
      </xsl:call-template>
      <xsl:text># </xsl:text>
      <xsl:value-of select="local-name(.)"/>
      <xsl:text>: </xsl:text>
      <xsl:value-of select="."/>
      <xsl:text>&#xD;</xsl:text>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
