<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema">
  <xsl:include href="textausrichtung.xslt"/>
  <xsl:output method="text" version="1.0" encoding="ISO-8859-1"/>
  <xsl:template match="//xs:annotation">
    <xsl:variable name="trenner1" select="' | '"/>
    <xsl:variable name="trenner2" select="':  '"/>
    <xsl:if test="not(local-name(parent::*)='schema')">
      <xsl:value-of select="local-name(parent::*)"/>
      <xsl:value-of select="$trenner1"/>
      <xsl:value-of select="parent::*/@name"/>
      <xsl:value-of select="$trenner2"/>
    </xsl:if>
    <xsl:variable name="grenze" select="concat(local-name(parent::*), $trenner1, $trenner2, parent::*/@name)"/>
    <xsl:for-each select="xs:documentation">
      <xsl:if test="not(position()=1)">
        <xsl:call-template name="Einzug">
          <xsl:with-param name="grenze" select="string-length($grenze)"/>
        </xsl:call-template>
      </xsl:if>
      <xsl:value-of select="."/>
      <xsl:text>&#xD;</xsl:text>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
