<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dok="http:www.ruhrfon.biz/doku">
  <xsl:include href="textausrichtung.xslt"/>
  <xsl:output method="text" version="1.0" encoding="ISO-8859-1" indent="yes"/>
  <!-- Wahl der kommentierten Elemente -->
  <xsl:template match="//*[@dok:dok]">
    <!-- Trennzeichen -->
    <xsl:variable name="trenner1" select="' | '"/>
    <xsl:variable name="trenner2" select="':  '"/>
    <!-- Ausgabeoptionen -->
    <xsl:variable name="spaltenbreite" select="50"/>
    <xsl:variable name="grenze" select="10"/>
    <!-- Ausgabe der Element-Informationen-->
    <xsl:value-of select="local-name(.)"/>
    <xsl:if test="@name">
      <xsl:value-of select="$trenner1"/>
      <xsl:value-of select="@name"/>
      <xsl:value-of select="$trenner2"/>
      <xsl:text>&#xD;</xsl:text>
    </xsl:if>
    <!-- Ausgabe der Dokumentation -->
    <xsl:choose>
      <!-- Einzeilige Ausgabe -->
      <xsl:when test="string-length(@dok:dok) &lt;= $spaltenbreite">
        <xsl:call-template name="Einzug">
          <xsl:with-param name="grenze" select="$grenze"/>
        </xsl:call-template>
        <xsl:value-of select="@dok:dok"/>
        <xsl:text>&#xD;</xsl:text>
      </xsl:when>
      <!-- Mehrzeilige Ausgabe -->
      <xsl:otherwise>
        <xsl:call-template name="Zeilenausgabe">
          <xsl:with-param name="text" select="@dok:dok"/>
          <xsl:with-param name="spaltenbreite" select="$spaltenbreite"/>
          <xsl:with-param name="grenze" select="$grenze"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- Berücksichtigung von zu langen Dokumentationen -->
  <xsl:template name="Zeilenausgabe">
    <xsl:param name="text"/>
    <xsl:param name="spaltenbreite"/>
    <xsl:param name="grenze"/>
    <xsl:call-template name="Einzug">
      <xsl:with-param name="grenze" select="$grenze"/>
    </xsl:call-template>
    <xsl:value-of select="substring($text, 1, $spaltenbreite)"/>
    <xsl:text>&#xD;</xsl:text>
    <xsl:if test="not(string-length(substring($text, $spaltenbreite+1))=0)">
      <!-- Rekursiver Aufruf für weitere Zeilen -->
      <xsl:call-template name="Zeilenausgabe">
        <xsl:with-param name="text" select="substring($text, $spaltenbreite+1)"/>
        <xsl:with-param name="spaltenbreite" select="$spaltenbreite"/>
        <xsl:with-param name="grenze" select="$grenze"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
