<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema">
  <xsl:output method="html" version="1.0" encoding="ISO-8859-1" indent="yes"/>
  <xsl:template match="/xs:schema">
    <html>
      <head>
        <title>Informationsübersicht</title>
      </head>
      <body>
        <h1>Elemente</h1>
        <ul>
          <xsl:apply-templates select="//xs:element"/>
        </ul>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="xs:element">
    <xsl:call-template name="Attribute"/>
    <xsl:if test="xs:complexType/child::*[local-name()='attribute']">
      <xsl:for-each select="descendant::xs:attribute">
        <xsl:call-template name="Attribute">
          <xsl:with-param name="letztesElement" select="@name"/>
        </xsl:call-template>
      </xsl:for-each>
    </xsl:if>
    <hr/>
  </xsl:template>
  <xsl:template name="Attribute">
    <xsl:param name="letztesElement"/>
    <li>
      <xsl:if test="local-name(.) = 'element'">
        <i>Element: </i>
      </xsl:if>
      <xsl:if test="local-name(.) = 'attribute'">
        <i>Attribut: </i>
      </xsl:if>
      <xsl:value-of select="@name | @ref"/>
    </li>
    <ul>
      <li>
        <b>Eigenschaften</b>
        <ol>
          <xsl:for-each select="@*[not(local-name(.)='name')]">
            <li>
              <b>
                <xsl:value-of select="local-name(.)"/>
              </b>
              <xsl:text>: </xsl:text>
              <xsl:value-of select="."/>
            </li>
          </xsl:for-each>
        </ol>
      </li>
    </ul>
  </xsl:template>
</xsl:stylesheet>
