<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema">
  <xsl:include href="textausrichtung.xslt"/>
  <xsl:output method="text" version="1.0" encoding="ISO-8859-1" indent="yes"/>
  <xsl:template match="/">
    <xsl:apply-templates select="node()"/>
  </xsl:template>
  <xsl:template match="node()">
    <xsl:variable name="vorfahren" select="count(ancestor::*)"/>
    <xsl:value-of select="$vorfahren"/>
    <xsl:call-template name="Einzug">
      <xsl:with-param name="grenze" select="$vorfahren*2"/>
    </xsl:call-template>
    <xsl:value-of select="local-name(.)"/>
    <xsl:text>&#xD;</xsl:text>
    <xsl:call-template name="Einzug">
      <xsl:with-param name="wert" select="'-'"/>
      <xsl:with-param name="grenze" select="40"/>
    </xsl:call-template>
    <xsl:text>&#xD;</xsl:text>
    <xsl:for-each select="@*">
      <xsl:call-template name="Einzug">
        <xsl:with-param name="grenze" select="$vorfahren*2"/>
      </xsl:call-template>
      <xsl:text>|-&gt; </xsl:text>
      <xsl:value-of select="local-name(.)"/>
      <xsl:text>: </xsl:text>
      <xsl:value-of select="."/>
      <xsl:text>&#xD;</xsl:text>
      <xsl:if test="position()=last()">
        <xsl:text>&#xD;</xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:apply-templates select="node()"/>
  </xsl:template>
</xsl:stylesheet>
