SET LONG 20000;

SELECT XMLELEMENT("Erfolg", XMLATTRIBUTES(P_Stadt AS "Stadt", TO_CHAR(A_Beginn, 'MM.YY') AS "Monat"),
        XMLELEMENT("Gesamt", 
         XMLFOREST(SUM(A_Preis)/100 AS "Umsatz",
                  COUNT(DISTINCT P_Nr) AS "ZahlKunden",
                  COUNT(DISTINCT A_Nr) AS "Anrufe")),
        XMLELEMENT("ProKopf", 
         XMLFOREST(ROUND((SUM(A_Preis)/100)/COUNT(DISTINCT P_Nr),2) AS "Umsatz",
                   ROUND(COUNT(DISTINCT A_Nr)/COUNT(DISTINCT P_Nr),2) AS "Anrufe"))) AS Text
  FROM PKunde INNER JOIN anruf
    ON pkunde.P_Nr = anruf.A_Von
 WHERE pkunde.P_Stadt = 'Essen, Ruhr'
   AND A_Beginn > '01.10.0004'
 GROUP BY TO_CHAR(A_Beginn, 'MM.YY'), P_Stadt
 ORDER BY TO_CHAR(A_Beginn, 'MM.YY') ASC;
 