SET LONG 20000;

SELECT XMLELEMENT("Neukunden", XMLATTRIBUTES(Monat AS "Monat"), Zuwachs,
        XMLELEMENT("Gesamt", Gesamt)) AS Text
FROM (
SELECT a.Monat AS Monat,
       (SELECT COUNT(*)
          FROM PKunde c
         WHERE EXTRACT(YEAR FROM c.P_Beginn) = 2003
           AND EXTRACT(MONTH FROM c.P_Beginn) <= a.Monat) AS Gesamt,
       a.Zahl AS Zuwachs
 FROM
(SELECT EXTRACT(MONTH FROM P_Beginn) AS Monat,
       COUNT(P_Nr) AS Zahl
  FROM PKunde
 WHERE EXTRACT(YEAR FROM P_Beginn) = 2003
 GROUP BY EXTRACT(MONTH FROM P_Beginn)) a
 GROUP BY a.Monat, a.Zahl);

