SET LONG 20000;

SELECT XMLELEMENT("Erfolg", XMLATTRIBUTES('Essen, Ruhr' AS "Stadt", Monat AS "Monat"),
        XMLELEMENT("Neukunden", Zuwachs),
        XMLELEMENT("Gesamt", Gesamt)) AS Text
FROM ( 
SELECT a.Monat AS Monat,
       (SELECT COUNT(*)
          FROM GKunde c
         WHERE EXTRACT(YEAR FROM c.G_Beginn) = 2003
           AND G_Stadt = 'Essen, Ruhr'
           AND EXTRACT(MONTH FROM c.G_Beginn) <= a.Monat) AS Zuwachs,
       a.Zahl AS Gesamt
 FROM
(SELECT EXTRACT(MONTH FROM d.G_Beginn) AS Monat,
       COUNT(d.G_Nr) AS Zahl
  FROM GKunde d
 WHERE EXTRACT(YEAR FROM d.G_Beginn) = 2003
   AND d.G_Stadt = 'Essen, Ruhr'
 GROUP BY EXTRACT(MONTH FROM d.G_Beginn)) a
 GROUP BY a.Monat, a.Zahl); 