SET LONG 20000;
SELECT XMLELEMENT("Umsatz", XMLATTRIBUTES('200' || EXTRACT(YEAR FROM A_Beginn) AS "Jahr"),
        XMLELEMENT("Tarif", XMLATTRIBUTES(T_Nr   AS "Nr"), T_Name),
        XMLELEMENT("Summe",
         XMLFOREST(ROUND(AVG(A_Preis) KEEP (DENSE_RANK FIRST
                    ORDER BY (A_Preis))/100,2) AS "Min",
                   ROUND(AVG(A_Preis) KEEP (DENSE_RANK LAST
                    ORDER BY (A_Preis))/100,2) AS "Max",
                   ROUND(AVG(A_Preis)/100,2) AS "Durchschnitt",
                   COUNT(A_Nr)               AS "Einzeln",
                   (SELECT COUNT(A_Nr) FROM anruf) AS "Anrufe"))) AS Text
FROM anruf INNER JOIN tarif
  ON anruf.A_TNr = tarif.T_Nr
GROUP BY T_Name, T_Nr, EXTRACT(YEAR FROM A_Beginn)
ORDER BY EXTRACT(YEAR FROM A_Beginn), T_Name, T_Nr; 