SET LONG 20000;
SELECT XMLELEMENT("Umsatz",
        XMLELEMENT("Tarif",
         XMLFOREST(T_Name AS "Name",
                   T_Typ AS "Typ",
                  '200' || EXTRACT(YEAR FROM A_Beginn) AS "Jahr")),
        XMLELEMENT("Summe",
         XMLFOREST(ROUND(SUM(A_Preis)/100,2) AS "da_SummeEinzeln",
                   SUM(ROUND(SUM(A_Preis)/100,2))
                    OVER (PARTITION BY T_Name) AS "da_SummeTarif",
                   SUM(ROUND(SUM(A_Preis)/100,2))
                    OVER ()            AS "da_SummeGesamt",
                   ROUND((RATIO_TO_REPORT(SUM(A_Preis))
                    OVER ())*100,2)                  AS "da_Prozent"))) AS Text        
  FROM anruf INNER JOIN tarif
  ON anruf.A_TNr = tarif.T_Nr
GROUP BY T_Name, T_Nr, EXTRACT(YEAR FROM A_Beginn), T_Typ
ORDER BY EXTRACT(YEAR FROM A_Beginn), T_Name, T_Nr; 