SET LONG 20000;
SELECT XMLELEMENT("Kunde", XMLATTRIBUTES('g' AS "Typ", G_Nr AS "Nr"),
        XMLFOREST(G_Name AS "Name",
                   G_Branche AS "Branche",
                   ROUND(SUM(A_Preis)/100,2) AS "Umsatz"),
        XMLELEMENT("Adresse",
         XMLFOREST(G_Strasse AS "Strasse",
                   G_PLZ AS "PLZ",
                   G_Stadt AS "Stadt")),
        XMLELEMENT("Telefon",
         XMLFOREST(G_Vorwahl AS "Vorwahl",
                   G_Telnr  AS "Telnr"))) AS Text
  FROM gkunde INNER JOIN anruf
    ON G_Nr = a_Von
 WHERE G_Nr IN (15)
   AND a_Typ = 'g'
 GROUP BY G_Nr, G_Name, G_Branche, G_Strasse, G_PLZ, G_Stadt, G_Vorwahl, G_Telnr;
 
SELECT XMLELEMENT("Kunde", XMLATTRIBUTES('p' AS "Typ", P_Nr AS "Nr"),
        XMLFOREST(P_Nachname AS "Nachname",
                  P_Vorname AS "Vorname",
                  ROUND(SUM(A_Preis)/100,2) AS "Umsatz"),
        XMLELEMENT("Adresse",
         XMLFOREST(P_Strasse AS "Strasse",
                   P_PLZ AS "PLZ",
                   P_Stadt AS "Stadt")),
        XMLELEMENT("Telefon",
         XMLFOREST(P_Vorwahl AS "Vorwahl",
                   P_Telnr  AS "Telnr"))) AS Text
  FROM pkunde INNER JOIN anruf
    ON P_Nr = a_Von
 WHERE P_Nr IN (1203)
   AND a_Typ = 'p'
 GROUP BY P_Nr, P_Nachname, P_Vorname, P_Strasse, P_PLZ, P_Stadt, P_Vorwahl, P_Telnr;