SET LONG 20000;
SELECT XMLELEMENT("Tarif", XMLATTRIBUTES(A_TNr AS "Nr", T_Typ AS "Typ"),
        XMLFOREST(T_Name AS "Name",        
                  T_Preis AS "Preis"),
        XMLELEMENT("Gueltigkeit",
         XMLFOREST(TO_CHAR(T_GueVon, 'YY-MM-DD') AS "Von",
                   TO_CHAR(T_GueBis, 'YY-MM-DD') AS "Bis")),
        XMLELEMENT("Uhrzeit",
         XMLFOREST(T_Ende AS "Von",
                   T_Beginn AS "Bis")),
        XMLELEMENT("Umsatz",
         XMLFOREST(COUNT(A_Nr) AS "Anrufe",
       (SELECT COUNT(DISTINCT A_Von)
          FROM anruf c
         WHERE a.A_TNr = c.A_TNr) AS "Kunden",         
                   ROUND(SUM(A_Preis)/100,2) AS "GesamtSumme",
       ROUND(ROUND(SUM(A_Preis)/100,2) /
       (SELECT COUNT(DISTINCT A_Von)
          FROM anruf c
         WHERE a.A_TNr = c.A_TNr),2) AS "ProKopfSumme"))) as text
  FROM anruf a INNER JOIN tarif b
    ON a.A_TNr = b.T_Nr
  GROUP BY A_TNr, T_Name, T_Preis, T_GueVon, T_GueBis, T_Beginn, T_Ende, T_Typ
  ORDER BY T_Name;