SET LONG 20000;
SELECT XMLELEMENT("rf_Umsatz",
        XMLELEMENT("rf_Tarif",
         XMLFOREST(T_Name AS "rf_Name",
                   T_Typ AS "rf_Typ",
                  '200' || EXTRACT(YEAR FROM A_Beginn) AS "rf_Jahr"),
         XMLELEMENT("rf_Gueltigkeit", XMLATTRIBUTES('Datum' AS "Typ"),
          XMLFOREST(TO_CHAR(T_GueVon, 'YY-MM-DD') AS "rf_GueVon",
                    TO_CHAR(T_GueBis, 'YY-MM-DD') AS "rf_GueBis"))),
        XMLELEMENT("rf_Summe",
         XMLFOREST(ROUND(SUM(A_Preis)/100,2) AS "rf_Einzeln",
                   SUM(ROUND(SUM(A_Preis)/100,2))
                    OVER (PARTITION BY T_Name) AS "rf_TarifGesamt",
                   SUM(ROUND(SUM(A_Preis)/100,2))
                    OVER ()            AS "rf_Gesamt",
                   ROUND((RATIO_TO_REPORT(SUM(A_Preis))
                    OVER ())*100,2)                  AS "rf_Prozent"))) AS Text        
  FROM anruf INNER JOIN tarif
  ON anruf.A_TNr = tarif.T_Nr
GROUP BY T_Name, T_Nr, EXTRACT(YEAR FROM A_Beginn), T_Typ, T_GueVon, T_GueBis
ORDER BY EXTRACT(YEAR FROM A_Beginn), T_Name, T_Nr; 